package com.bambooclod.eaccount3.api;

import android.content.Context;

import com.bambooclod.eaccount3.bean.PasswordAuthPara;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.eaccount3.callback.AuthCallByBindBack;
import com.bambooclod.eaccount3.callback.SingalAuthCallBack;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 密码认证
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class PasswordAuth {

    private PasswordAuth() {
    }

    public static final PasswordAuth authRequest = new PasswordAuth();

    public static PasswordAuth get() {
        return authRequest;
    }

    /**
     * 密码认证链
     *
     * @param context  Context
     * @param userName 用户名
     * @param password 密码
     * @param callBack 回调
     */
    public void passwordAuth(final Context context, String userName
            , String password, final AuthCallBack callBack) {

        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        PasswordAuthPara para = new PasswordAuthPara(userName, password, "");
        AuthRequest.get().doAuth(context, para, session, HttpConfig.AuthType.PWD, false, callBack);
    }

    /**
     * 密码认证链
     *
     * @param context  Context
     * @param userName 用户名
     * @param password 密码
     * @param callBack 回调
     */
    public void passwordAuth(final Context context, String userName
            , String password, final AuthCallByBindBack callBack) {

        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        PasswordAuthPara para = new PasswordAuthPara(userName, password, "");
        AuthRequest.get().doAuth(context, para, session, HttpConfig.AuthType.PWD, false, callBack);
    }

    /**
     * 密码单次认证
     *
     * @param context  Context
     * @param userName 用户名
     * @param password 密码
     * @param callBack 回调
     */
    public void singlePasswordAuth(final Context context, String userName
            , String password, final SingalAuthCallBack callBack) {

        PasswordAuthPara para = new PasswordAuthPara(userName, password, "");
        AuthRequest.get().commonAuth(context, para, HttpConfig.AuthType.PWD, false, callBack);
    }
}
