package com.bambooclod.eaccount3.bean;

import android.os.Build;

/**
 * Comment: DoAuth接口的基础实体
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-05
 * Email:wangpei@bamboocloud.cn
 */
public class DoAuthBaseData<T> {

    /**
     * appId : epass
     * authPara : {"loginName":"mazhiqiang","password":"123456"}
     * authType : pwd
     * device : pc
     * epsessionId :
     * hostname : pc
     * requestType : 1
     */

    private String appId;
    private T authPara;
    private String authType;
    private String device = "app";
    private String epsessionId;
    private String hostname = Build.MODEL;
    private String requestType = "1";
    private String deviceFingerprint = "";

    public DoAuthBaseData(String appId, T authPara, String authType) {
        this.appId = appId;
        this.authPara = authPara;
        this.authType = authType;
    }

    public DoAuthBaseData(String appId, T authPara, String authType, String epsessionId) {
        this.appId = appId;
        this.authPara = authPara;
        this.authType = authType;
        this.epsessionId = epsessionId;
    }

    public DoAuthBaseData(String appId, T authPara, String authType, String epsessionId, String deviceFingerprint) {
        this.appId = appId;
        this.authPara = authPara;
        this.authType = authType;
        this.epsessionId = epsessionId;
        this.deviceFingerprint = deviceFingerprint;
    }

    public DoAuthBaseData(String appId, T authPara, String authType, String epsessionId, String requestType, String deviceFingerprint) {
        this.appId = appId;
        this.authPara = authPara;
        this.authType = authType;
        this.epsessionId = epsessionId;
        this.requestType = requestType;
        this.deviceFingerprint = deviceFingerprint;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public T getAuthPara() {
        return authPara;
    }

    public void setAuthPara(T authPara) {
        this.authPara = authPara;
    }

    public String getAuthType() {
        return authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getEpsessionId() {
        return epsessionId;
    }

    public void setEpsessionId(String epsessionId) {
        this.epsessionId = epsessionId;
    }

    public String getHostname() {
        return hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getRequestType() {
        return requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getDeviceFingerprint() {
        return deviceFingerprint;
    }

    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    @Override
    public String toString() {
        return "DoAuthBaseData{" +
                "appId='" + appId + '\'' +
                ", authPara=" + authPara +
                ", authType='" + authType + '\'' +
                ", device='" + device + '\'' +
                ", epsessionId='" + epsessionId + '\'' +
                ", hostname='" + hostname + '\'' +
                ", requestType='" + requestType + '\'' +
                ", deviceFingerprint='" + deviceFingerprint + '\'' +
                '}';
    }
}
