package com.bambooclod.eaccount3.call;

import android.content.Context;
import android.view.View;
import android.widget.Toast;

import com.bambooclod.eaccount3.api.FaceAuth;
import com.bambooclod.eaccount3.api.FingerAuth;
import com.bambooclod.eaccount3.api.GestureAuth;
import com.bambooclod.eaccount3.api.PasswordAuth;
import com.bambooclod.eaccount3.api.QrAuth;
import com.bambooclod.eaccount3.api.SmsAuth;
import com.bambooclod.eaccount3.api.VoiceAuth;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.eaccount3.callback.AuxAuthCallBack;
import com.bambooclod.eaccount3.callback.SendSmsCallBack;
import com.bambooclod.eaccount3.callback.SingalAuthCallBack;
import com.bambooclod.eaccount3.view.AnimUtil;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.otp.Token;
import com.bambooclod.epassbase.otp.TokenCode;
import com.bambooclod.epassbase.otp.TokenPersistence;
import com.bambooclod.epassbase.sp.SPUtils;

import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.unit.Subunits;

/**
 * Comment: //人脸请求类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-29
 * Email:wangpei@bamboocloud.cn
 */
public class EpassAuthSDK {

    public static final EpassAuthSDK eaccount = new EpassAuthSDK();

    public static EpassAuthSDK Builder() {
        return eaccount;
    }

    public void init(Context context) {
        //适配
        AutoSizeConfig.getInstance().getUnitsManager()
                .setSupportDP(false)
                .setSupportSP(false)
                .setSupportSubunits(Subunits.MM);
    }

    private TokenCode mCodes;

    /**
     * 首次人脸认证
     * <p>
     * 使用设备指纹和人脸进行判断
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void faceAuth(Context context, String data, AuthCallBack callBack) {
        FaceAuth.get().firstFaceAuth(context, data, callBack);
    }

    /**
     * 人脸认证链认证
     */
    public void linkFaceAuth(final Context context, String data
            , final AuthCallBack callBack) {
        FaceAuth.get().facaLinkAuth(context, data, callBack);
    }

    /**
     * 人脸单次认证
     * <p>
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void faceSignalAuth(Context context, String data, SingalAuthCallBack callBack) {
        FaceAuth.get().faceSignalAuth(context, data, callBack);
    }

    /**
     * 人脸辅助认证
     */
    public void faceAuxAuth(final Context context, String data, final AuxAuthCallBack callBack) {
        FaceAuth.get().faceAuxAuth(context, data, callBack);
    }

    /**
     * 指纹辅助认证
     */
    public void auxFrAuth(final Context context, final AuxAuthCallBack callBack) {
        FingerAuth.get().auxFrAuth(context, callBack);
    }

    /**
     * 指纹单次认证
     */
    public void frSignalAuth(final Context context, final SingalAuthCallBack callBack) {
        FingerAuth.get().frSignalAuth(context, callBack);
    }

    /**
     * 指纹认证链认证
     */
    public void frLinkAuth(final Context context,  final AuthCallBack callBack) {
        FingerAuth.get().frLinkAuth(context, callBack);
    }

    /**
     * 手势单次认证
     */
    public void signalGestureAuth(Context context, String gesture
            , final SingalAuthCallBack callBack) {
        GestureAuth.get().signalGestureAuth(context, gesture, callBack);
    }

    /**
     * 手势认证链认证
     */
    public void linkGestureAuth(Context context, String gesture
            , final AuthCallBack callBack) {
        GestureAuth.get().linkGestureAuth(context, gesture, callBack);
    }

    /**
     * 手势辅助认证
     */
    public void auxGestureAuth(Context context, String gesture,
                               final AuxAuthCallBack callBack) {
        GestureAuth.get().auxGestureAuth(context, gesture, callBack);
    }

    /**
     * 密码认证链认证
     *
     * @param context  Context
     * @param userName 用户名
     * @param password 密码
     * @param callBack 回调
     */
    public void linkPasswordAuth(final Context context, String userName
            , String password, final AuthCallBack callBack) {

        PasswordAuth.get().passwordAuth(context, userName, password, callBack);
    }


    /**
     * 密码单次认证
     *
     * @param context  Context
     * @param userName 用户名
     * @param password 密码
     * @param callBack 回调
     */
    public void singlePasswordAuth(final Context context, String userName
            , String password, final SingalAuthCallBack callBack) {
        PasswordAuth.get().singlePasswordAuth(context, userName, password, callBack);
    }

    /**
     * 提供给Qr界面的认证方法
     *
     * @param context   Context
     * @param qrContent 二维码内容
     * @param callBack  回调
     */
    public void authQR(Context context, String qrContent
            , final AuthCallBack callBack) {
        QrAuth.get().authQR(context, qrContent, callBack);
    }

    /**
     * 绑定设备
     *
     * @param context        Context
     * @param verCode        验证码
     * @param deviceBindType 如果要绑定设备，则需要传递这个参数 1-临时信任 2-永久信任
     * @param callBack       回调
     */
    public void bindDevice(Context context, String verCode
            , String deviceBindType, AuthCallBack callBack) {

        SmsAuth.get().pwdIntoAuthForBind(context, verCode, false, deviceBindType, callBack);
    }

    /**
     * 绑定设备 短信入口则不需要传code
     *
     * @param context        Context
     * @param deviceBindType 如果要绑定设备，则需要传递这个参数 1-临时信任 2-永久信任
     * @param callBack       回调
     */
    public void bindDevice(Context context, String deviceBindType, AuthCallBack callBack) {
        SmsAuth.get().smsIntoAuthForsBind(context, deviceBindType, callBack);
    }

    /**
     * 短信认证链认证
     *
     * @param context     Context
     * @param phone       电话号码
     * @param verCode     验证码
     * @param callBack    回调
     */
    public void linkSmsAuth(Context context, String phone, String verCode
            , AuthCallBack callBack) {

        SmsAuth.get().smsAuth(context, phone, verCode, callBack);
    }

    /**
     * 短信单次认证
     *
     * @param context  Context
     * @param phone    电话号码
     * @param verCode  验证码
     * @param callBack 回调
     */
    public void singleSmsAuth(Context context, String phone, String verCode, SingalAuthCallBack callBack) {
        SmsAuth.get().singleSmsAuth(context, phone, verCode, callBack);
    }

    /**
     * 获取短信验证码
     *
     * @param context     Context
     * @param mobile      手机号码
     */
    public void sendSms(final Context context, String mobile
            , final SendSmsCallBack callBack) {
        SmsAuth.get().sendSms(context, "", mobile, callBack);
    }

    /**
     * 声纹首次认证
     * <p>
     * 无用户信息认证
     *
     * @param context  Context
     */
    public void voiceAuth(final Context context, String data, String readContent
            ,boolean isFirstAuth, final AuthCallBack callBack) {
        if(isFirstAuth) {
            //声纹首次认证
            VoiceAuth.get().voiceAuth(context, data, readContent, callBack);
        }else{
            //声纹认证链认证
            VoiceAuth.get().voiceLinkAuth(context, data, readContent, callBack);
        }
    }


    /**
     * 声纹单次认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceSignalAuth(final Context context, String data, String readContent
            , final SingalAuthCallBack callBack) {
        VoiceAuth.get().voiceSignalAuth(context, data, readContent, callBack);
    }

    /**
     * 声纹辅助认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceAuxAuth(final Context context, String data, String readContent
            , final AuxAuthCallBack callBack) {
        VoiceAuth.get().voiceAuxAuth(context, data, readContent, callBack);
    }


    public void setCardScaleAnimation(View view, boolean isDown) {
        AnimUtil.setCardScaleAnimation(view, isDown);
    }

    /**
     * 获取OTPKEY
     *
     * @return 如果有错误，则返回000000
     */
    public String getOTPKey(Context context) {
        //没有OTPKey，则不让进这个界面
        String otpKey = (String) SPUtils.get(context, InitConfigValue.USER_OTP_KEY, InitConfigValue.DEFAULT);
        if (otpKey.equals(InitConfigValue.DEFAULT)) {
            Toast.makeText(context, "当前没有OTP Key,无法生成动态码", Toast.LENGTH_SHORT).show();
            return "000000";
        }

        TokenPersistence tp = new TokenPersistence(context);
        if (tp.length() > 0) {
            Token token = tp.get(0);
            mCodes = token.generateCodes();
            tp.save(token);

            return token.generateCodes().getCurrentCode();
        } else {
            Toast.makeText(context, "当前没有OTP Key,无法生成动态码", Toast.LENGTH_SHORT).show();
            return "000000";
        }
    }

    /**
     * 获取Otp Code步长的当前时间
     *
     * @return Otp Current Second
     */
    public long getOTPSwitchRemainingTime() {
        if (mCodes != null) {
            return mCodes.getCurrentSecond();
        } else {
            return 0;
        }
    }


}
