package com.bambooclod.eaccount3.bean;

import android.support.annotation.NonNull;

/**
 * Comment: 手势认证的参数体
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-06
 * Email:wangpei@bamboocloud.cn
 */
public class GestureAuthPara {

    /**
     * userInfo : {"userId":"admin","loginName":"admin","email":"","mobileNum":"15296562230"}
     * modelId : 123456789
     */

    private UserInfoBean userInfo;
    private String modelId;
    private String deviceBindType = "";
    private String loginName;

    public GestureAuthPara() {
    }

    public GestureAuthPara(UserInfoBean userInfo, String modelId) {
        this.userInfo = userInfo;
        this.modelId = modelId;
    }

    public GestureAuthPara(String modelId, String loginName) {
        this.modelId = modelId;
        this.loginName = loginName;
    }

    public UserInfoBean getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public GestureAuthPara(UserInfoBean userInfo, String modelId, String deviceBindType) {
        this.userInfo = userInfo;
        this.modelId = modelId;
        this.deviceBindType = deviceBindType;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public GestureAuthPara(String modelId, String deviceBindType, String loginName) {
        this.modelId = modelId;
        this.deviceBindType = deviceBindType;
        this.loginName = loginName;
    }

    public String getDeviceBindType() {
        return deviceBindType;
    }

    public void setDeviceBindType(String deviceBindType) {
        this.deviceBindType = deviceBindType;
    }

    public static class UserInfoBean {
        /**
         * userId : admin
         * loginName : admin
         * email :
         * mobileNum : 15296562230
         */

        private String userId;
        private String loginName;
        private String email;
        private String mobileNum;

        public UserInfoBean(String userId, String loginName, String mobileNum) {
            this.userId = userId;
            this.loginName = loginName;
            this.mobileNum = mobileNum;
        }

        public UserInfoBean() {
        }

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getLoginName() {
            return loginName;
        }

        public void setLoginName(String loginName) {
            this.loginName = loginName;
        }

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getMobileNum() {
            return mobileNum;
        }

        public void setMobileNum(String mobileNum) {
            this.mobileNum = mobileNum;
        }

        @NonNull
        @Override
        public String toString() {
            return "UserInfoBean{" +
                    "userId='" + userId + '\'' +
                    ", loginName='" + loginName + '\'' +
                    ", email='" + email + '\'' +
                    ", mobileNum='" + mobileNum + '\'' +
                    '}';
        }
    }

    @NonNull
    @Override
    public String toString() {
        return "GestureAuthPara{" +
                "userInfo=" + userInfo.toString() +
                ", modelId='" + modelId + '\'' +
                '}';
    }
}
