package com.bambooclod.eaccount3.api;

import android.content.Context;
import android.util.Base64;
import android.widget.Toast;

import com.alibaba.fastjson.JSON;
import com.bambooclod.eaccount3.bean.JwtDecodeData;
import com.bambooclod.eaccount3.bean.QrAuthPara;
import com.bambooclod.eaccount3.bean.QrContentData;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: //todo
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class QrAuth {

    private QrAuth() {
    }

    public static final QrAuth authRequest = new QrAuth();

    public static QrAuth get() {
        return authRequest;
    }

    /**
     * 提供给Qr界面的认证方法
     *
     * @param context                   Context
     * @param qrContent                 二维码内容
     * @param mQrAuthCallBack 回调
     */
    public void authQR(Context context, String qrContent
            , final AuthCallBack mQrAuthCallBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        QrAuthPara para;
        QrContentData parseQrContent;
        if (InitConfigValue.DEFAULT.equals(jwt) && jwt != null) {
            Toast.makeText(context, "请登录后，再进行二维码扫描", Toast.LENGTH_SHORT).show();
            return;
        } else {
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            LogUtil.getInstance().w("Jwt:" + jwt);
            String[] forma = jwt.split("\\.");
            String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
            JwtDecodeData decodeData = JSON.parseObject(jwtContent, JwtDecodeData.class);

            QrAuthPara.UserInfoBean userInfoBean =
                    new QrAuthPara.UserInfoBean(decodeData.getUserid()
                            , decodeData.getUserid(), "");

            parseQrContent = JSON.parseObject(qrContent, QrContentData.class);
            para = new QrAuthPara(userInfoBean, parseQrContent.getCont());
        }

        AuthRequest.get().doAuth(context, para, parseQrContent.getCont()
                , HttpConfig.AuthType.QR, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess( String authList, String authedList) {
                        mQrAuthCallBack.doAuthSuccess(authList, authedList);
                    }

                    @Override
                    public void needBindDevice(String authList) {
                        mQrAuthCallBack.needBindDevice(authList);
                    }

                    @Override
                    public void error(String code, String message) {
                        mQrAuthCallBack.error(code, message);
                    }
                });
    }

}
