package com.bambooclod.eaccount3.api;

import android.app.Activity;
import android.content.Context;
import android.util.Base64;
import android.widget.Toast;

import com.alibaba.fastjson.JSON;
import com.bambooclod.eaccount3.bean.FingerAuthPara;
import com.bambooclod.eaccount3.bean.JwtDecodeData;
import com.bambooclod.eaccount3.biometriclib.BiometricPromptManager;
import com.bambooclod.eaccount3.callback.AuxAuthCallBack;
import com.bambooclod.eaccount3.callback.DoOrCommonAuthCallBack;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 指纹认证
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class FingerAuth {

    private FingerAuth() {
    }

    public static final FingerAuth authRequest = new FingerAuth();

    public static FingerAuth get() {
        return authRequest;
    }

    /**
     * 从JWT中获取用户信息
     *
     * @param jwt JWT
     * @return JwtDecodeData
     */
    private JwtDecodeData getUserInfoFromJWT(String jwt) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] forma = jwt.split("\\.");
        String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
        return JSON.parseObject(jwtContent, JwtDecodeData.class);
    }

    /**
     * 指纹辅助认证
     */
    public void auxFrAuth(final Context context, final AuxAuthCallBack callBack) {

        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        final FingerAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = getUserInfoFromJWT(jwt).getUserid();
            FingerAuthPara.UserInfoBean userInfoBean =
                    new FingerAuthPara.UserInfoBean(userID, userID, "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new FingerAuthPara(userInfoBean, "");
        } else {
            Toast.makeText(context, "当前内部无JWT数据，未登录，需要登录后才能调用此接口"
                    , Toast.LENGTH_SHORT).show();
            return;
        }

        checkFr(context, new BiometricPromptManager.OnBiometricIdentifyCallback() {
            @Override
            public void onUsePassword() {
                Toast.makeText(context, "使用密码逻辑"
                        , Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onSucceeded() {
                AuthRequest.get().doAuth(context, auxAuthPara, false, ""
                        , HttpConfig.AuthType.FR, false, new DoOrCommonAuthCallBack() {
                            @Override
                            public void doAuthSuccess(String sessionID, String authList, String authedList) {
                                if (callBack != null) {
                                    callBack.auxAuthSuccess();
                                }
                            }

                            @Override
                            public void doCommonAuthSuccess(boolean isSuccess) {
                            }

                            @Override
                            public void needBindDevice(String authList, String sessionID) {
                            }

                            @Override
                            public void error(String code, String message) {
                                if (callBack != null) {
                                    callBack.error(code, message);
                                }
                            }
                        });
            }

            @Override
            public void onFailed() {

            }

            @Override
            public void onError(int code, String reason) {

            }

            @Override
            public void onCancel() {

            }
        });
    }

    /**
     * 检测指纹是否为用户的
     */
    private void checkFr(Context context, BiometricPromptManager.OnBiometricIdentifyCallback callBack) {
        BiometricPromptManager manager = BiometricPromptManager.from((Activity) context);
        //判断是否有硬件支持
        if (!manager.isHardwareDetected()) {
            Toast.makeText(context, "当前设备不支持指纹解锁功能", Toast.LENGTH_SHORT).show();
        } else {
            //判断是否有指纹信息
            if (!manager.hasEnrolledFingerprints()) {
                Toast.makeText(context, "当前设备暂未设置指纹信息", Toast.LENGTH_SHORT).show();
            } else {
                //验证通过
                manager.authenticate(callBack);
            }
        }
    }

    /**
     * 指纹单次认证
     */
    public void frSignalAuth(final Context context, final DoOrCommonAuthCallBack callBack) {
        checkFr(context, new BiometricPromptManager.OnBiometricIdentifyCallback() {
            @Override
            public void onUsePassword() {
                Toast.makeText(context, "使用密码逻辑"
                        , Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onSucceeded() {
                doFingerSuccessResult(context, "", true, callBack);
            }

            @Override
            public void onFailed() {

            }

            @Override
            public void onError(int code, String reason) {

            }

            @Override
            public void onCancel() {

            }
        });
    }

    /**
     * 指纹认证链认证
     */
    public void frLinkAuth(final Context context, final String session, final DoOrCommonAuthCallBack callBack) {
        checkFr(context, new BiometricPromptManager.OnBiometricIdentifyCallback() {
            @Override
            public void onUsePassword() {
                Toast.makeText(context, "使用密码逻辑"
                        , Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onSucceeded() {
                doFingerSuccessResult(context, session, false, callBack);
            }

            @Override
            public void onFailed() {

            }

            @Override
            public void onError(int code, String reason) {

            }

            @Override
            public void onCancel() {

            }
        });
    }

    /**
     * 从Session中获取用户信息
     */
    private String getUserInfoFromSession(String session) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] format = session.split(":");
        return format[1];
    }

    /**
     * 处理指纹认证成功后的逻辑
     */
    private void doFingerSuccessResult(Context context, String epSessionId, boolean isSimpleCheck, DoOrCommonAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        FingerAuthPara para;
        FingerAuthPara.UserInfoBean userInfoBean;

        //只有单次才有JWT
        if (isSimpleCheck) {
            if (InitConfigValue.DEFAULT.equals(jwt)) {
                Toast.makeText(context, "当前内部无JWT数据，未登录，需要登录后才能调用此接口"
                        , Toast.LENGTH_SHORT).show();
                return;
            } else {
                //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
                String[] forma = jwt.split("\\.");
                String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
                JwtDecodeData decodeData = JSON.parseObject(jwtContent, JwtDecodeData.class);

                //单次
                userInfoBean =
                        new FingerAuthPara.UserInfoBean(decodeData.getUserid()
                                , decodeData.getUserid(), "");

                para = new FingerAuthPara(userInfoBean, "");
            }
            //认证链
        } else {
            //使用Session获取用户名
            if ("".equals(epSessionId) || InitConfigValue.DEFAULT.equals(epSessionId) || epSessionId == null) {
                Toast.makeText(context, "无Session参数，发生异常"
                        , Toast.LENGTH_SHORT).show();
                return;
            } else {
                para = new FingerAuthPara("", getUserInfoFromSession(epSessionId));
            }
        }
        AuthRequest.get().doAuth(context, para, isSimpleCheck, epSessionId, HttpConfig.AuthType.FR, false, callBack);
    }
}
