package com.bambooclod.eaccount3.api;

import android.content.Context;

import com.bambooclod.eaccount3.bean.PasswordAuthPara;
import com.bambooclod.eaccount3.callback.DoOrCommonAuthCallBack;
import com.bambooclod.epassbase.config.HttpConfig;

/**
 * Comment: 密码认证
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class PasswordAuth {

    private PasswordAuth() {
    }

    public static final PasswordAuth authRequest = new PasswordAuth();

    public static PasswordAuth get() {
        return authRequest;
    }


    /**
     * 密码认证  -- 绑定
     *
     * @param context        Context
     * @param userName       用户名
     * @param password       密码
     * @param isSimpleCheck  是否单次认证
     * @param epSessionId    会话ID
     * @param deviceBindType 如果要绑定设备，则需要传递这个参数 1-临时信任 2-永久信任
     * @param callBack       回调
     */
    private void passwordAuthForBind(final Context context, String userName
            , String password, final boolean isSimpleCheck
            , String epSessionId, String deviceBindType, final DoOrCommonAuthCallBack callBack) {

        if (deviceBindType == null) {
            deviceBindType = "";
        }

        PasswordAuthPara para = new PasswordAuthPara(userName, password, deviceBindType);
        AuthRequest.get().doAuth(context, para, isSimpleCheck, epSessionId, HttpConfig.AuthType.PWD, true, callBack);
    }

    /**
     * 密码认证
     *
     * @param context       Context
     * @param userName      用户名
     * @param password      密码
     * @param isSimpleCheck 是否单次认证
     * @param epSessionId   会话ID
     * @param callBack      回调
     */
    public void passwordAuth(final Context context, String userName
            , String password, final boolean isSimpleCheck
            , String epSessionId, final DoOrCommonAuthCallBack callBack) {

        PasswordAuthPara para = new PasswordAuthPara(userName, password, "");
        AuthRequest.get().doAuth(context, para, isSimpleCheck, epSessionId, HttpConfig.AuthType.PWD, false, callBack);
    }
}
