package com.bambooclod.eaccount3.view;

import android.animation.ObjectAnimator;
import android.view.View;

/**
 * Comment: 动画工具类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-12
 * Email:wangpei@bamboocloud.cn
 */
public class AnimUtil {

    /**
     * 设置卡片点击效果
     *
     * @param view   目标视图
     * @param isDown 是否点击下
     */
    public static void setCardScaleAnimation(View view, boolean isDown) {
        if (isDown) {
            ObjectAnimator.ofFloat(view, "scaleX"
                    , 1f, 0.90f)
                    .setDuration(300)
                    .start();

            ObjectAnimator.ofFloat(view, "scaleY"
                    , 1f, 0.90f)
                    .setDuration(300)
                    .start();
        } else {
            ObjectAnimator.ofFloat(view, "scaleX"
                    , 0.90f, 1f)
                    .setDuration(300)
                    .start();

            ObjectAnimator.ofFloat(view, "scaleY"
                    , 0.90f, 1f)
                    .setDuration(300)
                    .start();
        }
    }
}
