package com.bambooclod.eaccount3.callback;

/**
 * Comment: 密码认证回调
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-05
 * Email:wangpei@bamboocloud.cn
 */
public interface DoOrCommonAuthCallBack {

    /**
     * 统一密码认证成功
     *
     * @param sessionID  会话ID
     * @param authList   还需认证类型列表
     * @param authedList 已经认证类型列表
     */
    void doAuthSuccess(String sessionID, String authList, String authedList);

    /**
     * 单次密码认证成功
     *
     * @param isSuccess 是否成功
     */
    void doCommonAuthSuccess(boolean isSuccess);


    /**
     * 需要进行设备绑定
     *
     * @param authList  需要进行的绑定认证类型
     * @param sessionID 会话ID
     */
    void needBindDevice(String authList, String sessionID);

    /**
     * 请求出错
     *
     * @param code    服务器返回错误码
     * @param message 服务器提示信息
     */
    void error(String code, String message);
}
