package com.bambooclod.eaccount3.bean;

import android.support.annotation.NonNull;

/**
 * Comment: 单次认证接口基础实体
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-05
 * Email:wangpei@bamboocloud.cn
 */
public class CommonAuthBaseData<T> {

    /**
     * authPara : 认证具体参数
     * authType : 认证类型,pwd、fr、qr等
     */

    private T authPara;
    private String authType;

    public T getAuthPara() {
        return authPara;
    }

    public void setAuthPara(T authPara) {
        this.authPara = authPara;
    }

    public String getAuthType() {
        return authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public CommonAuthBaseData(T authPara, String authType) {
        this.authPara = authPara;
        this.authType = authType;
    }

    @NonNull
    @Override
    public String toString() {
        return "CommonAuthBaseData{" +
                "authPara='" + authPara + '\'' +
                ", authType='" + authType + '\'' +
                '}';
    }
}
