package com.bambooclod.eaccount3.bean;

/**
 * Comment: 声纹辅助认证
 *
 * 辅助：userinfo+data doAuth
 * 单次：userinfo+data commonAuth
 * 认证链认证：logname+data doAuth
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-21
 * Email:wangpei@bamboocloud.cn
 */
public class VoiceAuxAuthPara {


    /**
     * userInfo : {"userId":"aaa","loginName":"aaa","email":"bamboocloud@cn","mobileNum":"13888888888"}
     * deviceFingerprint : A4:50:46:7C:55:C9
     * voiceData : /9j/4QAYRXhpZgAASUkqAAgAAAAAAAAAAAAAAP/sABFEdWNreQABAAQAAAA8AAD/4QMdaHR
     */

    private UserInfoBean userInfo;
    private String deviceFingerprint;
    private String voiceData;
    private String loginName;

    public VoiceAuxAuthPara(String voiceData, String loginName) {
        this.voiceData = voiceData;
        this.loginName = loginName;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public UserInfoBean getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getDeviceFingerprint() {
        return deviceFingerprint;
    }

    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public String getVoiceData() {
        return voiceData;
    }

    public void setVoiceData(String voiceData) {
        this.voiceData = voiceData;
    }

    public static class UserInfoBean {
        /**
         * userId : aaa
         * loginName : aaa
         * email : bamboocloud@cn
         * mobileNum : 13888888888
         */

        private String userId;
        private String loginName;
        private String email;
        private String mobileNum;

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getLoginName() {
            return loginName;
        }

        public void setLoginName(String loginName) {
            this.loginName = loginName;
        }

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getMobileNum() {
            return mobileNum;
        }

        public void setMobileNum(String mobileNum) {
            this.mobileNum = mobileNum;
        }

        public UserInfoBean(String userId, String loginName, String email, String mobileNum) {
            this.userId = userId;
            this.loginName = loginName;
            this.email = email;
            this.mobileNum = mobileNum;
        }
    }

    public VoiceAuxAuthPara(UserInfoBean userInfo, String deviceFingerprint, String voiceData) {
        this.userInfo = userInfo;
        this.deviceFingerprint = deviceFingerprint;
        this.voiceData = voiceData;
    }

    @Override
    public String toString() {
        return "VoiceAuxAuthPara{" +
                "userInfo=" + userInfo +
                ", deviceFingerprint='" + deviceFingerprint + '\'' +
                ", voiceData='" + voiceData + '\'' +
                '}';
    }
}
