package com.bambooclod.eaccount3.api;

import android.content.Context;
import android.util.Base64;
import android.widget.Toast;

import com.alibaba.fastjson.JSON;
import com.bambooclod.eaccount3.bean.GestureAuthPara;
import com.bambooclod.eaccount3.bean.JwtDecodeData;
import com.bambooclod.eaccount3.callback.DoOrCommonAuthCallBack;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 手势认证
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class GestureAuth {

    private GestureAuth() {
    }

    public static final GestureAuth authRequest = new GestureAuth();

    public static GestureAuth get() {
        return authRequest;
    }

    /**
     * 手势单次认证
     */
    public void signalGestureAuth(Context context, String gesture
            , final DoOrCommonAuthCallBack callBack) {
        authGesture(context, true, "", gesture, callBack);
    }

    /**
     * 手势认证链认证
     */
    public void linkGestureAuth(Context context, String gesture, String session
            , final DoOrCommonAuthCallBack callBack) {
        authGesture(context, false, session, gesture, callBack);
    }

    /**
     * 从JWT中获取用户信息
     *
     * @param jwt JWT
     * @return JwtDecodeData
     */
    private JwtDecodeData getUserInfoFromJWT(String jwt) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] forma = jwt.split("\\.");
        String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
        return JSON.parseObject(jwtContent, JwtDecodeData.class);
    }

    /**
     * 手势辅助认证
     */
    public void auxGestureAuth(Context context, String gesture, final DoOrCommonAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        GestureAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = getUserInfoFromJWT(jwt).getUserid();
            GestureAuthPara.UserInfoBean userInfoBean =
                    new GestureAuthPara.UserInfoBean(userID, userID, "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new GestureAuthPara(userInfoBean, gesture);
        } else {
            Toast.makeText(context, "当前内部无JWT数据，未登录，需要登录后才能调用此接口"
                    , Toast.LENGTH_SHORT).show();
            return;
        }

        AuthRequest.get().doAuth(context, auxAuthPara, false, ""
                , HttpConfig.AuthType.GESTURE, false, new DoOrCommonAuthCallBack() {
                    @Override
                    public void doAuthSuccess(String sessionID, String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(sessionID, authList, authedList);
                        }
                    }

                    @Override
                    public void doCommonAuthSuccess(boolean isSuccess) {
                        if (callBack != null) {
                            callBack.doCommonAuthSuccess(isSuccess);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList, String sessionID) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList, sessionID);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 从Session中获取用户信息
     */
    private String getUserInfoFromSession(String session) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] format = session.split(":");
        return format[1];
    }

    /**
     * 单次或者认证链认证
     */
    private void authGesture(Context context, boolean isSimpleCheck, String session, String gesture
            , final DoOrCommonAuthCallBack mDoOrCommonAuthCallBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        GestureAuthPara.UserInfoBean userInfoBean;
        GestureAuthPara gestureAuthPara;

        //单次要校验JWT，认证链不用
        if (isSimpleCheck) {
            if (InitConfigValue.DEFAULT.equals(jwt)) {
                //单次和认证链都要jwt
                Toast.makeText(context, "当前内部无JWT数据，未登录，需要登录后才能调用此接口"
                        , Toast.LENGTH_SHORT).show();
                return;
            } else {
                //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
                String[] forma = jwt.split("\\.");
                String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
                JwtDecodeData decodeData = JSON.parseObject(jwtContent, JwtDecodeData.class);

                //单次
                userInfoBean =
                        new GestureAuthPara.UserInfoBean(decodeData.getUserid()
                                , decodeData.getUserid(), "");

                gestureAuthPara = new GestureAuthPara(userInfoBean, gesture);
            }

        } else {
            //使用Session获取用户名
            if ("".equals(session) || InitConfigValue.DEFAULT.equals(session) || session == null) {
                Toast.makeText(context, "无Session参数，发生异常"
                        , Toast.LENGTH_SHORT).show();
                return;
            } else {
                gestureAuthPara = new GestureAuthPara(gesture, getUserInfoFromSession(session));
            }
        }

        AuthRequest.get().doAuth(context, gestureAuthPara, isSimpleCheck, session
                , HttpConfig.AuthType.GESTURE, false, new DoOrCommonAuthCallBack() {
                    @Override
                    public void doAuthSuccess(String sessionID, String authList, String authedList) {
                        mDoOrCommonAuthCallBack.doAuthSuccess(sessionID, authList, authedList);
                    }

                    @Override
                    public void doCommonAuthSuccess(boolean isSuccess) {
                        mDoOrCommonAuthCallBack.doCommonAuthSuccess(isSuccess);
                    }

                    @Override
                    public void needBindDevice(String authList, String sessionID) {
                        mDoOrCommonAuthCallBack.needBindDevice(authList, sessionID);
                    }

                    @Override
                    public void error(String code, String message) {
                        mDoOrCommonAuthCallBack.error(code, message);
                    }
                });
    }

}
