package com.bambooclod.eaccount3.call;

import android.content.Context;

import com.bambooclod.eaccount3.api.FaceAuth;
import com.bambooclod.eaccount3.api.FingerAuth;
import com.bambooclod.eaccount3.api.GestureAuth;
import com.bambooclod.eaccount3.api.PasswordAuth;
import com.bambooclod.eaccount3.api.QrAuth;
import com.bambooclod.eaccount3.api.SmsAuth;
import com.bambooclod.eaccount3.api.VoiceAuth;
import com.bambooclod.eaccount3.callback.DoOrCommonAuthCallBack;
import com.bambooclod.eaccount3.callback.SendSmsCallBack;

/**
 * Comment: //人脸请求类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-29
 * Email:wangpei@bamboocloud.cn
 */
public class EpassAuth {

    public static final EpassAuth eaccount = new EpassAuth();

    public static EpassAuth Builder() {
        return eaccount;
    }

    /**
     * 首次人脸认证
     * <p>
     * 使用设备指纹和人脸进行判断
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void firstFaceAuth(Context context, String data, DoOrCommonAuthCallBack callBack) {
        FaceAuth.get().firstFaceAuth(context, data, callBack);
    }

    /**
     * 人脸单次认证
     * <p>
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void faceSignalAuth(Context context, String data, DoOrCommonAuthCallBack callBack) {
        FaceAuth.get().faceSignalAuth(context,data,callBack);
    }

    /**
     * 人脸认证链认证
     */
    public void facaLinkAuth(final Context context, final String session, String data
            , final DoOrCommonAuthCallBack callBack) {
        FaceAuth.get().facaLinkAuth(context,session,data,callBack);
    }

    /**
     * 人脸辅助认证
     */
    public void faceAuxAuth(final Context context, String data, final DoOrCommonAuthCallBack callBack) {
        FaceAuth.get().faceAuxAuth(context,data,callBack);
    }

    /**
     * 指纹辅助认证
     */
    public void auxFrAuth(final Context context, final DoOrCommonAuthCallBack callBack) {
        FingerAuth.get().auxFrAuth(context,callBack);
    }

    /**
     * 指纹单次认证
     */
    public void frSignalAuth(final Context context, final DoOrCommonAuthCallBack callBack) {
        FingerAuth.get().frSignalAuth(context,callBack);
    }

    /**
     * 指纹认证链认证
     */
    public void frLinkAuth(final Context context, final String session, final DoOrCommonAuthCallBack callBack) {
        FingerAuth.get().frLinkAuth(context,session,callBack);
    }

    /**
     * 手势单次认证
     */
    public void signalGestureAuth(Context context, String gesture
            , final DoOrCommonAuthCallBack callBack) {
        GestureAuth.get().signalGestureAuth(context,gesture,callBack);
    }

    /**
     * 手势认证链认证
     */
    public void linkGestureAuth(Context context, String gesture, String session
            , final DoOrCommonAuthCallBack callBack) {
        GestureAuth.get().linkGestureAuth(context,gesture,session,callBack);
    }

    /**
     * 手势辅助认证
     */
    public void auxGestureAuth(Context context, String gesture,
                               final DoOrCommonAuthCallBack callBack) {
        GestureAuth.get().auxGestureAuth(context,gesture,callBack);
    }

    /**
     * 密码认证
     *
     * @param context       Context
     * @param userName      用户名
     * @param password      密码
     * @param isSimpleCheck 是否单次认证
     * @param epSessionId   会话ID
     * @param callBack      回调
     */
    public void passwordAuth(final Context context, String userName
            , String password, final boolean isSimpleCheck
            , String epSessionId, final DoOrCommonAuthCallBack callBack) {
        PasswordAuth.get().passwordAuth(context,userName,password,isSimpleCheck
        ,epSessionId,callBack);
    }

    /**
     * 提供给Qr界面的认证方法
     *
     * @param context                   Context
     * @param qrContent                 二维码内容
     * @param callBack 回调
     */
    public void authQR(Context context, String qrContent
            , final DoOrCommonAuthCallBack callBack) {
        QrAuth.get().authQR(context,qrContent,callBack);
    }

    /**
     * 短信认证（以密码作为认证入口）  -- 绑定
     *
     * @param context        Context
     * @param phone          电话号码
     * @param verCode        验证码
     * @param isSimpleCheck  是否单次认证
     * @param epSessionId    会话ID
     * @param deviceBindType 如果要绑定设备，则需要传递这个参数 1-临时信任 2-永久信任
     * @param callBack       回调
     */
    public void pwdIntoAuthForBind(Context context, String phone, String verCode
            , boolean isSimpleCheck, String epSessionId, String deviceBindType, DoOrCommonAuthCallBack callBack) {

        SmsAuth.get().pwdIntoAuthForBind(context,phone,verCode,isSimpleCheck,epSessionId,deviceBindType,callBack);
    }

    /**
     * 短信认证（以短信作为认证入口）  -- 绑定
     *
     * @param context        Context
     * @param epSessionId    会话ID
     * @param deviceBindType 如果要绑定设备，则需要传递这个参数 1-临时信任 2-永久信任
     * @param callBack       回调
     */
    public void smsIntoAuthForsBind(Context context
            , String epSessionId, String deviceBindType, DoOrCommonAuthCallBack callBack) {
        SmsAuth.get().smsIntoAuthForsBind(context,epSessionId,deviceBindType,callBack);
    }

    /**
     * 短信认证
     *
     * @param context       Context
     * @param phone         电话号码
     * @param verCode       验证码
     * @param isSimpleCheck 是否单次认证
     * @param epSessionId   会话ID
     * @param callBack      回调
     */
    public void smsAuth(Context context, String phone, String verCode
            , boolean isSimpleCheck, String epSessionId, DoOrCommonAuthCallBack callBack) {
        SmsAuth.get().smsAuth(context,phone,verCode,isSimpleCheck,epSessionId,callBack);
    }

    /**
     * 获取短信验证码
     *
     * @param context     Context
     * @param epsessionId 会话ID
     * @param mobile      手机号码
     */
    public void sendSms(final Context context, String epsessionId, String mobile
            , final SendSmsCallBack callBack) {
        SmsAuth.get().sendSms(context,epsessionId,mobile,callBack);
    }

    /**
     * 声纹首次认证
     * <p>
     * 无用户信息认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceAuth(final Context context, String data, String readContent
            , final DoOrCommonAuthCallBack callBack) {
        VoiceAuth.get().voiceAuth(context,data,readContent,callBack);
    }

    /**
     * 声纹单次认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceSignalAuth(final Context context, String data, String readContent
            , final DoOrCommonAuthCallBack callBack) {
        VoiceAuth.get().voiceSignalAuth(context,data,readContent,callBack);
    }

    /**
     * 声纹认证链认证
     */
    public void voiceLinkAuth(final Context context, final String session, String data
            , String readContent, final DoOrCommonAuthCallBack callBack) {
        VoiceAuth.get().voiceLinkAuth(context,session,data,readContent,callBack);
    }

    /**
     * 声纹辅助认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceAuxAuth(final Context context, String data, String readContent
            , final DoOrCommonAuthCallBack callBack) {
        VoiceAuth.get().voiceAuxAuth(context,data,readContent,callBack);
    }






























}
