package com.bambooclod.eaccount3.api;

import android.content.Context;
import android.widget.Toast;

import com.bambooclod.eaccount3.bean.FaceFirstAuthPara;
import com.bambooclod.eaccount3.bean.FaceSignalAuthPara;
import com.bambooclod.eaccount3.callback.DoOrCommonAuthCallBack;
import com.bambooclod.epassbase.api.EpassUtils;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 人脸认证相关
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-27
 * Email:wangpei@bamboocloud.cn
 */
public class FaceAuth {

    private FaceAuth() {
    }

    public static final FaceAuth authRequest = new FaceAuth();

    public static FaceAuth get() {
        return authRequest;
    }

    /**
     * 首次人脸认证
     * <p>
     * 使用设备指纹和人脸进行判断
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void firstFaceAuth(final Context context, String data, final DoOrCommonAuthCallBack callBack) {
        FaceFirstAuthPara para = new FaceFirstAuthPara(EpassUtils.get().getDeviceID(context)
                , data);

        AuthRequest.get().doAuth(context, para, false, ""
                , HttpConfig.AuthType.FACE, false, new DoOrCommonAuthCallBack() {
                    @Override
                    public void doAuthSuccess(String sessionID, String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(sessionID, authList, authedList);
                        }
                    }

                    @Override
                    public void doCommonAuthSuccess(boolean isSuccess) {
                        if (callBack != null) {
                            callBack.doCommonAuthSuccess(isSuccess);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList, String sessionID) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList, sessionID);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }


    /**
     * 人脸单次认证
     * <p>
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void faceSignalAuth(final Context context, String data, final DoOrCommonAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        FaceSignalAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = AuthRequest.get().getUserInfoFromJWT(jwt).getUserid();
            FaceSignalAuthPara.UserInfoBean userInfoBean =
                    new FaceSignalAuthPara.UserInfoBean(userID, userID, "", "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new FaceSignalAuthPara(userInfoBean, EpassUtils.get().getDeviceID(context)
                    , data);
        } else {
            Toast.makeText(context, "当前内部无JWT数据，未登录，需要登录后才能调用此接口"
                    , Toast.LENGTH_SHORT).show();
            return;
        }

        AuthRequest.get().doAuth(context, auxAuthPara, true, ""
                , HttpConfig.AuthType.FACE, false, new DoOrCommonAuthCallBack() {
                    @Override
                    public void doAuthSuccess(String sessionID, String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(sessionID, authList, authedList);
                        }
                    }

                    @Override
                    public void doCommonAuthSuccess(boolean isSuccess) {
                        if (callBack != null) {
                            callBack.doCommonAuthSuccess(isSuccess);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList, String sessionID) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList, sessionID);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 人脸认证链认证
     */
    public void facaLinkAuth(final Context context, final String session, String data, final DoOrCommonAuthCallBack callBack) {

        FaceSignalAuthPara auxAuthPara;
        //使用Session获取用户名
        if ("".equals(session) || InitConfigValue.DEFAULT.equals(session) || session == null) {
            Toast.makeText(context, "无Session参数，发生异常"
                    , Toast.LENGTH_SHORT).show();
            return;
        } else {
            auxAuthPara = new FaceSignalAuthPara(data, getUserInfoFromSession(session));
        }

        AuthRequest.get().doAuth(context, auxAuthPara, false, session
                , HttpConfig.AuthType.FACE, false, new DoOrCommonAuthCallBack() {
                    @Override
                    public void doAuthSuccess(String sessionID, String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(sessionID, authList, authedList);
                        }
                    }

                    @Override
                    public void doCommonAuthSuccess(boolean isSuccess) {
                        if (callBack != null) {
                            callBack.doCommonAuthSuccess(isSuccess);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList, String sessionID) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList, sessionID);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 从Session中获取用户信息
     */
    private String getUserInfoFromSession(String session) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] format = session.split(":");
        return format[1];
    }

    /**
     * 人脸辅助认证
     */
    public void faceAuxAuth(final Context context, String data, final DoOrCommonAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        FaceSignalAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = AuthRequest.get().getUserInfoFromJWT(jwt).getUserid();
            FaceSignalAuthPara.UserInfoBean userInfoBean =
                    new FaceSignalAuthPara.UserInfoBean(userID, userID, "", "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new FaceSignalAuthPara(userInfoBean, EpassUtils.get().getDeviceID(context)
                    , data);
        } else {
            Toast.makeText(context, "当前内部无JWT数据，未登录，需要登录后才能调用此接口"
                    , Toast.LENGTH_SHORT).show();
            return;
        }

        AuthRequest.get().doAuth(context, auxAuthPara, false, ""
                , HttpConfig.AuthType.FACE, false, new DoOrCommonAuthCallBack() {
                    @Override
                    public void doAuthSuccess(String sessionID, String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(sessionID, authList, authedList);
                        }
                    }

                    @Override
                    public void doCommonAuthSuccess(boolean isSuccess) {
                        if (callBack != null) {
                            callBack.doCommonAuthSuccess(isSuccess);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList, String sessionID) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList, sessionID);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }
}
