/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.business;

import cn.authing.core.Authing;
import cn.authing.core.business.AuthingResponse;
import cn.authing.core.business.HttpHelper;
import cn.authing.core.business.ImportantParam;
import cn.authing.core.http.Call;
import cn.authing.core.param.CheckLoginStatusParam;
import cn.authing.core.param.LoginByEmailParam;
import cn.authing.core.param.LoginByLADPParam;
import cn.authing.core.param.LoginByOidcParam;
import cn.authing.core.param.LoginByPhoneParam;
import cn.authing.core.param.RefreshOidcTokenParam;
import cn.authing.core.param.RefreshSigninTokenParam;
import cn.authing.core.param.RefreshTokenParam;
import cn.authing.core.param.RegisterParam;
import cn.authing.core.param.ResetPasswordParam;
import cn.authing.core.param.SigninParam;
import cn.authing.core.param.UpdateUserInfoParam;
import cn.authing.core.param.UserInfoParam;
import cn.authing.core.param.UserListParam;
import cn.authing.core.result.CheckLoginStatusResult;
import cn.authing.core.result.LoginResult;
import cn.authing.core.result.RefreshOidcTokenResult;
import cn.authing.core.result.RefreshSigninTokenResult;
import cn.authing.core.result.RefreshTokenResult;
import cn.authing.core.result.RegisterResult;
import cn.authing.core.result.SigninResult;
import cn.authing.core.result.UserInfoResult;
import cn.authing.core.result.UserListResult;
import cn.authing.core.service.UserService;
import cn.authing.core.utils.AuthingUtils;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\b\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\b\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\b\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\b\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00062\u0006\u0010\b\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00062\u0006\u0010\b\u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00062\u0006\u0010\b\u001a\u00020$H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00062\u0006\u0010\b\u001a\u00020'H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\fH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\b\u001a\u00020*H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u00062\u0006\u0010\b\u001a\u00020,H\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\b\u001a\u00020.H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\b\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcn/authing/core/business/UserServiceImpl;", "Lcn/authing/core/service/UserService;", "helper", "Lcn/authing/core/business/HttpHelper;", "(Lcn/authing/core/business/HttpHelper;)V", "checkLoginStatus", "Lcn/authing/core/http/Call;", "Lcn/authing/core/result/CheckLoginStatusResult;", "param", "Lcn/authing/core/param/CheckLoginStatusParam;", "createUser", "Lcn/authing/core/result/RegisterResult;", "Lcn/authing/core/param/RegisterParam;", "getUserInfo", "Lcn/authing/core/result/UserInfoResult;", "Lcn/authing/core/param/UserInfoParam;", "list", "Lcn/authing/core/result/UserListResult;", "Lcn/authing/core/param/UserListParam;", "loginByEmail", "Lcn/authing/core/result/LoginResult;", "Lcn/authing/core/param/LoginByEmailParam;", "loginByLDAP", "Lcn/authing/core/param/LoginByLADPParam;", "loginByOidc", "Lcn/authing/core/result/SigninResult;", "Lcn/authing/core/param/LoginByOidcParam;", "loginByPhone", "Lcn/authing/core/param/LoginByPhoneParam;", "logout", "", "refreshOidcToken", "Lcn/authing/core/result/RefreshOidcTokenResult;", "Lcn/authing/core/param/RefreshOidcTokenParam;", "refreshSignInToken", "Lcn/authing/core/result/RefreshSigninTokenResult;", "Lcn/authing/core/param/RefreshSigninTokenParam;", "refreshToken", "Lcn/authing/core/result/RefreshTokenResult;", "Lcn/authing/core/param/RefreshTokenParam;", "register", "resetPassword", "Lcn/authing/core/param/ResetPasswordParam;", "signIn", "Lcn/authing/core/param/SigninParam;", "updateUserInfo", "Lcn/authing/core/param/UpdateUserInfoParam;", "user", "core"})
public final class UserServiceImpl
implements UserService {
    private final HttpHelper helper;

    @Override
    @NotNull
    public Call<RegisterResult> register(@NotNull RegisterParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return HttpHelper.createAuthingCall$default(this.helper, AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<RegisterResult>>(){}, param, null, 8, null);
    }

    @Override
    @NotNull
    public Call<LoginResult> loginByEmail(@NotNull LoginByEmailParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createLoginCall(AuthingUtils.INSTANCE.getURL_USER(), param);
    }

    @Override
    @NotNull
    public Call<LoginResult> loginByPhone(@NotNull LoginByPhoneParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createLoginCall(AuthingUtils.INSTANCE.getURL_USER(), param);
    }

    @Override
    @NotNull
    public Call<LoginResult> loginByLDAP(@NotNull LoginByLADPParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createLoginCall(AuthingUtils.INSTANCE.getURL_USER(), param);
    }

    @Override
    @NotNull
    public Call<UserInfoResult> getUserInfo(@NotNull UserInfoParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createAuthingCall(AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<UserInfoResult>>(){}, param, ImportantParam.INSTANCE.getOwnerToken());
    }

    @Override
    @NotNull
    public Call<UserInfoResult> updateUserInfo(@NotNull UpdateUserInfoParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createAuthingCall(AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<UserInfoResult>>(){}, param, ImportantParam.INSTANCE.getOwnerToken());
    }

    @Override
    @NotNull
    public Call<UserInfoResult> resetPassword(@NotNull ResetPasswordParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return HttpHelper.createAuthingCall$default(this.helper, AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<UserInfoResult>>(){}, param, null, 8, null);
    }

    @Override
    @NotNull
    public Call<RefreshTokenResult> refreshToken(@NotNull RefreshTokenParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createTokenCall(AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<RefreshTokenResult>>(){}, param, ImportantParam.INSTANCE.getOwnerToken());
    }

    private final void logout() {
        ImportantParam.INSTANCE.setUserToken(null);
    }

    @Override
    @NotNull
    public Call<RegisterResult> createUser(@NotNull RegisterParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.register(param);
    }

    @Override
    @NotNull
    public Call<UserListResult> list(@NotNull UserListParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        Call<UserListResult> call = Authing.getUserManageService().getUserList(param);
        Intrinsics.checkExpressionValueIsNotNull(call, (String)"Authing.getUserManageService().getUserList(param)");
        return call;
    }

    @Override
    @NotNull
    public Call<UserInfoResult> user(@NotNull UserInfoParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.getUserInfo(param);
    }

    @Override
    @NotNull
    public Call<SigninResult> signIn(@NotNull SigninParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return HttpHelper.createTokenCall$default(this.helper, AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<SigninResult>>(){}, param, null, 8, null);
    }

    @Override
    @NotNull
    public Call<RefreshSigninTokenResult> refreshSignInToken(@NotNull RefreshSigninTokenParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return HttpHelper.createAuthingCall$default(this.helper, AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<RefreshSigninTokenResult>>(){}, param, null, 8, null);
    }

    @Override
    @NotNull
    public Call<CheckLoginStatusResult> checkLoginStatus(@NotNull CheckLoginStatusParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return HttpHelper.createAuthingCall$default(this.helper, AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<CheckLoginStatusResult>>(){}, param, null, 8, null);
    }

    @Override
    @NotNull
    public Call<SigninResult> loginByOidc(@NotNull LoginByOidcParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        String string = AuthingUtils.INSTANCE.getURL_CORE();
        Map<String, String> map = param.getParams();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"param.params");
        return this.helper.createLoginByOidcCall(string, SigninResult.class, map);
    }

    @Override
    @NotNull
    public Call<RefreshOidcTokenResult> refreshOidcToken(@NotNull RefreshOidcTokenParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        String string = AuthingUtils.INSTANCE.getURL_CORE();
        HashMap<String, String> hashMap = param.getParams();
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"param.params");
        return this.helper.createNormalPostCall(string, RefreshOidcTokenResult.class, hashMap);
    }

    public UserServiceImpl(@NotNull HttpHelper helper) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        this.helper = helper;
    }
}

