/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.socket2.HandlerCreator;
import cn.atomicer.zephyr.io.socket2.SocketServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;

public class SocketServerInitializer<I>
extends ChannelInitializer<SocketChannel> {
    private HandlerCreator<I> handlerCreator;

    public SocketServerInitializer(HandlerCreator<I> handlerCreator) {
        this.handlerCreator = handlerCreator;
    }

    protected void initChannel(SocketChannel channel) throws Exception {
        if (this.handlerCreator == null) {
            throw new IllegalArgumentException("server handler must be not null");
        }
        ChannelPipeline pipeline = channel.pipeline();
        SocketServerHandler<I> serverHandler = this.handlerCreator.createServerHandler();
        pipeline.addLast(new ChannelHandler[]{serverHandler.getDecoder()});
        pipeline.addLast(new ChannelHandler[]{serverHandler.getEncoder()});
        pipeline.addLast(new ChannelHandler[]{serverHandler});
    }
}

