/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.coding.MessageEncoder;
import cn.atomicer.zephyr.io.socket2.AbstractHandler;
import cn.atomicer.zephyr.io.socket2.Buf2MessageDecoder;
import cn.atomicer.zephyr.io.socket2.CodecCreator;
import cn.atomicer.zephyr.io.socket2.Message2BufEncoder;
import io.netty.channel.ChannelHandlerContext;

public class SocketServerHandler<I>
extends AbstractHandler<I> {
    public SocketServerHandler(CodecCreator<Message2BufEncoder<I>> encoderCreator, CodecCreator<Buf2MessageDecoder<I>> decoderCreator) {
        super(encoderCreator, decoderCreator);
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Object message) throws Exception {
        String msgType = message == null ? "null-msg" : String.valueOf(message);
        this.log.debug((Object)String.format("read message, content: %s, ctx: %s", msgType, channelHandlerContext));
        if (message != null && MessageEncoder.PING.equals(message)) {
            channelHandlerContext.writeAndFlush((Object)MessageEncoder.PONG);
        }
        this.onMessage.doAction(channelHandlerContext, message);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.log.debug((Object)String.format("channel active: %s", ctx));
        ctx.fireChannelActive();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.log.debug((Object)String.format("channel read complete: %s", ctx));
        ctx.flush();
    }
}

