/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.socket2.HandlerCreator;
import cn.atomicer.zephyr.io.socket2.SocketServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;

public class SocketServer {
    private int port;
    private int bossThreads = 1;
    private int workerThreads = 1;
    private ServerBootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private SocketServerInitializer<?> handlerInitializer;

    private SocketServer(int port) {
        this.port = port;
    }

    private void init() {
        this.bootstrap = new ServerBootstrap();
        this.bossGroup = new NioEventLoopGroup(this.bossThreads);
        this.workerGroup = new NioEventLoopGroup(this.workerThreads);
        ((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(this.handlerInitializer);
    }

    public ChannelFuture startUp() {
        return this.bootstrap.bind(this.port);
    }

    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public static class Builder<T> {
        private SocketServer server;
        private HandlerCreator<T> handlerCreator;

        public Builder(int port) {
            this.server = new SocketServer(port);
        }

        public Builder<T> setBossThread(int threads) {
            if (threads >= 0) {
                this.server.bossThreads = threads;
            }
            return this;
        }

        public Builder<T> setWorkerThread(int threads) {
            if (threads >= 0) {
                this.server.workerThreads = threads;
            }
            return this;
        }

        public Builder<T> setHandlerCreator(HandlerCreator<T> handlerCreator) {
            this.handlerCreator = handlerCreator;
            return this;
        }

        public SocketServer build() {
            if (this.handlerCreator == null) {
                throw new IllegalArgumentException("server handler creator must be not null");
            }
            this.server.handlerInitializer = new SocketServerInitializer<T>(this.handlerCreator);
            this.server.init();
            return this.server;
        }
    }
}

