/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.socket2.HandlerCreator;
import cn.atomicer.zephyr.io.socket2.SocketClientHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;

public class SocketClientInitializer<I>
extends ChannelInitializer<SocketChannel> {
    private HandlerCreator<I> handlerCreator;

    public SocketClientInitializer(HandlerCreator<I> handlerCreator) {
        this.handlerCreator = handlerCreator;
    }

    protected void initChannel(SocketChannel channel) throws Exception {
        if (this.handlerCreator == null) {
            throw new IllegalArgumentException("client creator must be not null");
        }
        ChannelPipeline pipeline = channel.pipeline();
        SocketClientHandler<I> clientHandler = this.handlerCreator.createClientHandler();
        pipeline.addLast(new ChannelHandler[]{clientHandler.getDecoder()});
        pipeline.addLast(new ChannelHandler[]{clientHandler.getEncoder()});
        pipeline.addLast(new ChannelHandler[]{clientHandler});
    }
}

