/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.socket2.HandlerCreator;
import cn.atomicer.zephyr.io.socket2.SocketClientInitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

public class SocketClient {
    private EventLoopGroup group;
    private Bootstrap bootstrap;
    private int threads = 0;
    private String host;
    private int port;
    private SocketClientInitializer<?> handlerInitializer;

    private SocketClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    private void init() {
        this.group = new NioEventLoopGroup(this.threads);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler(this.handlerInitializer);
    }

    public ChannelFuture newConnect() {
        return this.bootstrap.connect(this.host, this.port);
    }

    public void shutdown() {
        this.group.shutdownGracefully();
    }

    public static class Builder<T> {
        private SocketClient skClient;
        private HandlerCreator<T> handlerCreator;

        public Builder(String host, int port) {
            this.skClient = new SocketClient(host, port);
        }

        public Builder<T> setThread(int threads) {
            if (threads >= 0) {
                this.skClient.threads = threads;
            }
            return this;
        }

        public Builder<T> setHandlerCreator(HandlerCreator<T> handlerCreator) {
            this.handlerCreator = handlerCreator;
            return this;
        }

        public SocketClient build() {
            if (this.handlerCreator == null) {
                throw new IllegalArgumentException("client handler creator must be not null");
            }
            this.skClient.handlerInitializer = new SocketClientInitializer<T>(this.handlerCreator);
            this.skClient.init();
            return this.skClient;
        }
    }
}

