/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.functions.Action2;
import cn.atomicer.zephyr.io.socket2.Buf2MessageDecoder;
import cn.atomicer.zephyr.io.socket2.CodecCreator;
import cn.atomicer.zephyr.io.socket2.Message2BufEncoder;
import cn.atomicer.zephyr.io.socket2.SocketClientHandler;
import cn.atomicer.zephyr.io.socket2.SocketServerHandler;
import io.netty.channel.ChannelHandlerContext;

public class HandlerCreator<I> {
    private final CodecCreator<Message2BufEncoder<I>> encoderCreator;
    private final CodecCreator<Buf2MessageDecoder<I>> decoderCreator;
    private Action2<ChannelHandlerContext, I> onMessage;
    private Action2<ChannelHandlerContext, Throwable> onError;

    public HandlerCreator(CodecCreator<Message2BufEncoder<I>> encoderCreator, CodecCreator<Buf2MessageDecoder<I>> decoderCreator) {
        this.encoderCreator = encoderCreator;
        this.decoderCreator = decoderCreator;
    }

    public HandlerCreator<I> setAction(Action2<ChannelHandlerContext, I> onMessage, Action2<ChannelHandlerContext, Throwable> onError) {
        this.onMessage = onMessage;
        this.onError = onError;
        return this;
    }

    public SocketClientHandler<I> createClientHandler() {
        SocketClientHandler<I> handler = new SocketClientHandler<I>(this.encoderCreator, this.decoderCreator);
        handler.setAction(this.onMessage, this.onError);
        return handler;
    }

    public SocketServerHandler<I> createServerHandler() {
        SocketServerHandler<I> handler = new SocketServerHandler<I>(this.encoderCreator, this.decoderCreator);
        handler.setAction(this.onMessage, this.onError);
        return handler;
    }
}

