/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.coding.Decoder;
import cn.atomicer.zephyr.io.coding.MessageDecoder;
import cn.atomicer.zephyr.io.model.Message;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class Buf2MessageDecoder<T>
extends ByteToMessageDecoder {
    private Decoder<T> decoder;

    public Buf2MessageDecoder(Decoder<T> decoder) {
        this.decoder = decoder;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> out) throws Exception {
        T message;
        if (byteBuf.readableBytes() < 8) {
            return;
        }
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        this.decoder.write(bytes, bytes.length);
        while ((message = this.decoder.poolMessage()) != null) {
            out.add(message);
        }
    }

    public static Buf2MessageDecoder<Message> getDefault() {
        return new Buf2MessageDecoder<Message>(new MessageDecoder());
    }
}

