/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket2;

import cn.atomicer.zephyr.io.functions.Action2;
import cn.atomicer.zephyr.io.socket2.Buf2MessageDecoder;
import cn.atomicer.zephyr.io.socket2.CodecCreator;
import cn.atomicer.zephyr.io.socket2.Message2BufEncoder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHandler<I>
extends SimpleChannelInboundHandler {
    Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private CodecCreator<Message2BufEncoder<I>> encoderCreator;
    private CodecCreator<Buf2MessageDecoder<I>> decoderCreator;
    Action2<ChannelHandlerContext, I> onMessage;
    Action2<ChannelHandlerContext, Throwable> onError;
    private static final Action2<ChannelHandlerContext, Throwable> DEFAULT_ON_ERROR = new Action2<ChannelHandlerContext, Throwable>(){

        @Override
        public void doAction(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        }
    };
    private static final Action2 DEFAULT_ON_MESSAGE = new Action2<ChannelHandlerContext, Object>(){

        @Override
        public void doAction(ChannelHandlerContext channelHandlerContext, Object t) throws Exception {
        }
    };

    AbstractHandler(CodecCreator<Message2BufEncoder<I>> encoderCreator, CodecCreator<Buf2MessageDecoder<I>> decoderCreator) {
        this.encoderCreator = encoderCreator;
        this.decoderCreator = decoderCreator;
        this.setAction(null, null);
    }

    public AbstractHandler<I> setAction(Action2<ChannelHandlerContext, I> onMessage, Action2<ChannelHandlerContext, Throwable> onError) {
        this.onMessage = onMessage != null ? onMessage : DEFAULT_ON_MESSAGE;
        this.onError = onError != null ? onError : DEFAULT_ON_ERROR;
        return this;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.onError.doAction(ctx, cause);
        super.exceptionCaught(ctx, cause);
    }

    public Message2BufEncoder<I> getEncoder() throws Exception {
        return (Message2BufEncoder)((Object)this.encoderCreator.apply());
    }

    public Buf2MessageDecoder<I> getDecoder() throws Exception {
        return (Buf2MessageDecoder)((Object)this.decoderCreator.apply());
    }
}

