/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket;

import cn.atomicer.zephyr.io.coding.MessageDecoder;
import cn.atomicer.zephyr.io.functions.Action;
import cn.atomicer.zephyr.io.functions.Function;
import cn.atomicer.zephyr.io.model.Message;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Dealing {
    private MessageDecoder decoder = new MessageDecoder();
    private Queue<Message> outputMessages = new ConcurrentLinkedQueue<Message>();
    private Action<Throwable> onReadError = DEFAULT_ON_ERROR;
    private Action<Throwable> onWriteError = DEFAULT_ON_ERROR;
    private static Action<Throwable> DEFAULT_ON_ERROR = new Action<Throwable>(){

        @Override
        public void doAction(Throwable key) {
        }
    };

    public void onAccept() {
    }

    public void onConnect() {
    }

    public void onReadable(Function<MessageDecoder, Integer> func) {
        try {
            func.apply(this.decoder);
        }
        catch (Exception e) {
            this.onReadError.doAction(e);
        }
    }

    public void onWriteable(Function<Message, Integer> func) {
        Message message = this.outputMessages.poll();
        if (message == null) {
            return;
        }
        try {
            func.apply(message);
        }
        catch (Exception e) {
            this.onWriteError.doAction(e);
        }
    }

    public Message poolInputMessage() {
        return this.decoder.poolMessage();
    }

    public boolean addOutputMessage(Message message) {
        return this.outputMessages.add(message);
    }

    public void setOnReadError(Action<Throwable> onReadError) {
        this.onReadError = onReadError;
    }

    public void setOnWriteError(Action<Throwable> onWriteError) {
        this.onWriteError = onWriteError;
    }
}

