/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket;

import cn.atomicer.zephyr.io.socket.MessageChannel;
import cn.atomicer.zephyr.io.socket.ServerChannel;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChannelSelector
implements Runnable {
    private Selector selector = Selector.open();
    private IOException throwCause;
    private AtomicBoolean closed = new AtomicBoolean();

    public SelectionKey channelRegister(SocketChannel channel, int ops, Object attachment) throws IOException {
        if (this.throwCause != null) {
            throw this.throwCause;
        }
        this.selector.wakeup();
        return channel.register(this.selector, ops, attachment);
    }

    public static int clientOps() {
        return 13;
    }

    public static int serverOps() {
        return 21;
    }

    @Override
    public void run() {
        while (!this.closed.get()) {
            try {
                int keyNum = this.selector.select();
                if (keyNum <= 0) continue;
                Set<SelectionKey> keySet = this.selector.selectedKeys();
                this.iterate(keySet);
            }
            catch (IOException e) {
                this.throwCause = e;
                break;
            }
        }
    }

    public void iterate(Set<SelectionKey> keys) throws IOException {
        Iterator<SelectionKey> iterator = keys.iterator();
        while (iterator.hasNext()) {
            MessageChannel messageChannel;
            SelectionKey key = iterator.next();
            if (key.isAcceptable()) {
                messageChannel = new ServerChannel((SocketChannel)key.channel());
                key.attach(messageChannel);
                messageChannel.doAction(16);
            } else {
                messageChannel = (MessageChannel)key.attachment();
                if (key.isConnectable()) {
                    messageChannel.finishConnect();
                    messageChannel.doAction(8);
                } else if (key.isReadable()) {
                    messageChannel.doAction(1);
                } else if (key.isWritable()) {
                    messageChannel.doAction(4);
                }
            }
            iterator.remove();
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void close() throws IOException {
        this.closed.set(true);
        this.selector.close();
    }
}

