/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.socket;

import cn.atomicer.zephyr.io.coding.MessageDecoder;
import cn.atomicer.zephyr.io.coding.MessageEncoder;
import cn.atomicer.zephyr.io.functions.Action;
import cn.atomicer.zephyr.io.functions.Function;
import cn.atomicer.zephyr.io.model.Message;
import cn.atomicer.zephyr.io.socket.Dealing;
import cn.atomicer.zephyr.io.socket.MessageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class AbstractChannel
implements MessageChannel {
    private Dealing dealing = new Dealing();
    private MessageEncoder encoder = new MessageEncoder();
    SocketChannel channel;

    @Override
    public int read(MessageDecoder messageDecoder) throws IOException {
        int read;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int count = 0;
        while ((read = this.channel.read(buffer)) > 0) {
            count += read;
            messageDecoder.write(buffer.array(), read);
            buffer.clear();
        }
        return count;
    }

    @Override
    public int write(Message message) throws IOException {
        byte[] bytes = this.encoder.encode(message);
        return this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        int count = 0;
        while (buffer.hasRemaining()) {
            count += this.channel.write(buffer);
        }
        return count;
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.channel.finishConnect();
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void doAction(int ops) {
        switch (ops) {
            case 16: {
                this.dealing.onAccept();
                break;
            }
            case 8: {
                this.dealing.onConnect();
                break;
            }
            case 1: {
                this.dealing.onReadable(new Function<MessageDecoder, Integer>(){

                    @Override
                    public Integer apply(MessageDecoder decoder) throws Exception {
                        return AbstractChannel.this.read(decoder);
                    }
                });
                break;
            }
            case 4: {
                this.dealing.onWriteable(new Function<Message, Integer>(){

                    @Override
                    public Integer apply(Message message) throws Exception {
                        return AbstractChannel.this.write(message);
                    }
                });
                break;
            }
        }
    }

    @Override
    public MessageChannel setOnError(Action<Throwable> onReadError, Action<Throwable> onWriteError) {
        this.dealing.setOnReadError(onReadError);
        this.dealing.setOnWriteError(onWriteError);
        return this;
    }

    @Override
    public Dealing getDealing() {
        return this.dealing;
    }
}

