/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.recipient;

import cn.atomicer.zephyr.io.functions.Action2;
import cn.atomicer.zephyr.io.model.Message;
import cn.atomicer.zephyr.io.model.MessageTypeEnum;
import cn.atomicer.zephyr.io.model.Recipient;
import cn.atomicer.zephyr.io.socket2.CodecCreator;
import cn.atomicer.zephyr.io.socket2.HandlerCreator;
import cn.atomicer.zephyr.io.socket2.SocketClient;
import cn.atomicer.zephyr.io.socket2.SocketServer;
import cn.atomicer.zephyr.io.util.ObjectUtil;
import com.google.gson.Gson;
import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecipientServer {
    private Log log = LogFactory.getLog(this.getClass());
    private SocketServer server;
    private Recipient recipient;

    public RecipientServer(SocketServer server, Recipient recipient) {
        ObjectUtil.ensureNotNull(recipient);
        ObjectUtil.ensureNotNull(server);
        this.recipient = recipient;
        this.server = server;
    }

    public void registerRecipient(String host, int port) throws InterruptedException {
        HandlerCreator<Message> handlerCreator = new HandlerCreator<Message>(CodecCreator.DEFAULT_ENCODER_CREATOR, CodecCreator.DEFAULT_DECODER_CREATOR).setAction(new Action2<ChannelHandlerContext, Message>(){

            @Override
            public void doAction(ChannelHandlerContext channelHandlerContext, Message message) throws Exception {
                RecipientServer.this.log.info((Object)String.format("Recipient register finished, %s", message));
                channelHandlerContext.close();
            }
        }, new Action2<ChannelHandlerContext, Throwable>(){

            @Override
            public void doAction(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
                RecipientServer.this.log.warn((Object)"Recipient register failed", throwable);
                channelHandlerContext.close();
            }
        });
        SocketClient client = new SocketClient.Builder<Message>(host, port).setHandlerCreator(handlerCreator).build();
        Message message = new Message(MessageTypeEnum.RECIPIENT_REGISTER.value());
        message.setContent(new Gson().toJson((Object)this.recipient).getBytes());
        client.newConnect().sync().channel().writeAndFlush((Object)message).channel().closeFuture().sync();
    }

    public SocketServer getServer() {
        return this.server;
    }
}

