/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.coding;

import cn.atomicer.zephyr.io.coding.Encoder;
import cn.atomicer.zephyr.io.model.Message;
import cn.atomicer.zephyr.io.model.MessageParameterEnum;
import cn.atomicer.zephyr.io.model.MessageTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class MessageEncoder
implements Encoder<Message> {
    public static final Message PING = new Message(MessageTypeEnum.PING.value());
    public static final Message PONG = new Message(MessageTypeEnum.PONG.value());

    @Override
    public byte[] encode(Message message) {
        if (MessageTypeEnum.PING.value().equals(message.getType()) || MessageTypeEnum.PING.value().equals(message.getType())) {
            String str = message.getType() + MessageParameterEnum.MSG_END.value();
            return str.getBytes();
        }
        HashMap<String, byte[]> kv = new HashMap<String, byte[]>();
        if (message.getMsgId() != null) {
            kv.put(MessageParameterEnum.MSG_ID.value(), message.getMsgId().getBytes());
        }
        if (message.getAppId() != null) {
            kv.put(MessageParameterEnum.APP_ID.value(), message.getAppId().getBytes());
        }
        if (message.getType() != null) {
            kv.put(MessageParameterEnum.TYPE.value(), message.getType().getBytes());
        }
        if (message.getContent() != null) {
            kv.put(MessageParameterEnum.CONTENT.value(), message.getContent());
        }
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        for (Map.Entry entry : kv.entrySet()) {
            byte[] sub1 = ((String)entry.getKey() + MessageParameterEnum.PARAM_SEPARATOR.value()).getBytes();
            byte[] sub2 = (byte[])entry.getValue();
            byte[] line = ArrayUtils.addAll((byte[])sub1, (byte[])sub2);
            lines.add(line);
        }
        byte[] joinArray = null;
        for (byte[] line : lines) {
            joinArray = ArrayUtils.addAll(joinArray, (byte[])line);
            joinArray = ArrayUtils.addAll((byte[])joinArray, (byte[])MessageParameterEnum.LINE_DELIMITER.value().getBytes());
        }
        return ArrayUtils.addAll(joinArray, (byte[])MessageParameterEnum.MSG_END.value().getBytes());
    }
}

