/*
 * Decompiled with CFR 0.152.
 */
package cn.atomicer.zephyr.io.coding;

import cn.atomicer.zephyr.io.coding.Decoder;
import cn.atomicer.zephyr.io.model.Message;
import cn.atomicer.zephyr.io.model.MessageParameterEnum;
import cn.atomicer.zephyr.io.model.MessageTypeEnum;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.ArrayUtils;

public class MessageDecoder
implements Decoder<Message> {
    private byte[] buffer;
    private Queue<Message> messages = new ConcurrentLinkedQueue<Message>();
    private Map<String, Object> kv = new HashMap<String, Object>();
    private Gson gson = new Gson();

    @Override
    public synchronized void write(byte[] bytes, int offset) {
        if (this.buffer == null) {
            this.buffer = new byte[offset];
            System.arraycopy(bytes, 0, this.buffer, 0, offset);
        } else {
            int len = bytes.length + offset;
            byte[] appendArray = new byte[len];
            System.arraycopy(this.buffer, 0, appendArray, 0, this.buffer.length);
            System.arraycopy(bytes, 0, appendArray, 0, offset);
            this.buffer = appendArray;
        }
        this.decode();
    }

    @Override
    public Message poolMessage() {
        return this.messages.poll();
    }

    private void decode() {
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        int start = 0;
        for (int offset = 0; offset < this.buffer.length && offset + 1 < this.buffer.length; ++offset) {
            if (this.buffer[offset] != 13 || this.buffer[offset + 1] != 10) continue;
            byte[] sub = ArrayUtils.subarray((byte[])this.buffer, (int)start, (int)offset);
            lines.add(sub);
            start = ++offset + 1;
        }
        this.buffer = ArrayUtils.subarray((byte[])this.buffer, (int)start, (int)this.buffer.length);
        for (byte[] line : lines) {
            if (line.length == 4) {
                String str = new String(line);
                if (MessageTypeEnum.PING.value().equals(str) || MessageTypeEnum.PONG.value().equals(str)) {
                    this.kv.put(MessageParameterEnum.TYPE.value(), str);
                    continue;
                }
            }
            if (line.length == 0 && this.kv.size() > 0) {
                Message message = (Message)this.gson.fromJson(this.gson.toJson(this.kv), Message.class);
                this.messages.add(message);
                this.kv = new HashMap<String, Object>();
                continue;
            }
            if (line.length == 0) continue;
            int index = ArrayUtils.indexOf((byte[])line, (byte)MessageParameterEnum.PARAM_SEPARATOR.value().getBytes()[0]);
            if (index < 0) {
                throw new RuntimeException("Separator not found.");
            }
            String key = new String(ArrayUtils.subarray((byte[])line, (int)0, (int)index));
            byte[] value = ArrayUtils.subarray((byte[])line, (int)(index + 1), (int)line.length);
            if (!key.equals(MessageParameterEnum.CONTENT.value())) {
                this.kv.put(key, new String(value));
                continue;
            }
            this.kv.put(key, value);
        }
    }

    public boolean interruptible() {
        return this.buffer.length == 0 || this.buffer.length == 4 && MessageParameterEnum.MSG_END.value().equals(new String(this.buffer));
    }
}

