package cn.aorise.common.component.common;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;

import java.io.Serializable;
import java.lang.reflect.Type;

import cn.aorise.common.component.network.entity.response.AccountInfo;
import cn.aorise.common.core.config.AoriseConstant;
import cn.aorise.common.core.module.network.APICallback;
import cn.aorise.common.core.ui.base.BaseActivity;
import cn.aorise.common.core.utils.assist.AoriseLog;
import cn.aorise.common.core.utils.assist.AoriseUtil;
import cn.aorise.common.core.utils.assist.DebugUtil;
import cn.aorise.common.core.utils.system.AppUtil;
import rx.Subscriber;

/**
 * Created by Administrator on 2015/11/6 0006.
 */
public class Utils {
    private static final String TAG = "common.Utils";

    public static final String PACKAGE_NAME_KEY = "PACKAGE_NAME_KEY";
    public static final String LOGIN_CLASS_NAME_KEY = "LOGIN_CLASS_NAME_KEY";

    /**
     * common
     **********************************************************************************************/


    /**
     * private
     **********************************************************************************************/

    /**
     * 创建联网请求mock模式
     *
     * @param activity
     * @param mockPath
     * @param aClass
     * @param callback
     * @param <T>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> Subscriber<T> mockSubscriber(BaseActivity activity, String mockPath, Class<T> aClass, APICallback<T> callback) {
        AoriseLog.i(TAG, "DebugUtil.isDebug() = " + DebugUtil.isDebug());
        return AoriseUtil.mockSubscriber(DebugUtil.isDebug(), activity, mockPath, aClass, callback);
    }

    /**
     * 创建联网请求mock模式
     *
     * @param activity
     * @param mockPath
     * @param typeOfT
     * @param callback
     * @param <T>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> Subscriber<T> mockSubscriber(BaseActivity activity, String mockPath, Type typeOfT, APICallback<T> callback) {
        AoriseLog.i(TAG, "DebugUtil.isDebug() = " + DebugUtil.isDebug());
        return AoriseUtil.mockSubscriber(DebugUtil.isDebug(), activity, mockPath, typeOfT, callback);
    }

    /**
     * 进入配置的首页
     *
     * @param activity    Activity上下文
     * @param accountInfo 登录后返回的账号信息
     */
    @Deprecated
    public static void gotoMainActivity(Activity activity, AccountInfo accountInfo) {
        String packageName = AppUtil.getAppSource(activity, PACKAGE_NAME_KEY);
        String className = AppUtil.getAppSource(activity, LOGIN_CLASS_NAME_KEY);
        AoriseLog.d("packageName:" + packageName);
        AoriseLog.d("className:" + className);
        if (null == packageName || null == className) {
            AoriseLog.e("请配置首页跳转地址");
            return;
        }

        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setComponent(new ComponentName(packageName, className));

        Bundle bundle = new Bundle();
        bundle.putString(AoriseConstant.AccountKey.USER_ACCOUNT,
                (null == accountInfo) ? "" : accountInfo.getAccount());
        bundle.putString(AoriseConstant.AccountKey.USER_ID,
                (null == accountInfo) ? "" : accountInfo.getId());
        bundle.putString(AoriseConstant.AccountKey.USER_SEX,
                (null == accountInfo) ? "" : accountInfo.getSex());
        intent.putExtras(bundle);

        activity.startActivity(intent);
        activity.finish();
    }

    /**
     * 进入配置的目标页面
     *
     * @param activity Activity上下文
     * @param value    透传数据
     */
    public static void gotoTargetActivity(Activity activity, Serializable value) {
        String packageName = AppUtil.getAppSource(activity, PACKAGE_NAME_KEY);
        String className = AppUtil.getAppSource(activity, LOGIN_CLASS_NAME_KEY);
        gotoTargetActivity(activity, value, packageName, className);
    }

    /**
     * 进入配置的目标页面
     *
     * @param activity    Activity上下文
     * @param value       透传数据
     * @param packageName 跳转页面的APP包名 "cn.aorise.sample"
     * @param className   跳转页面的class类名 "cn.aorise.sample.ui.activity.MainActivity"
     */
    public static void gotoTargetActivity(Activity activity, Serializable value, String packageName, String className) {
        AoriseLog.d("packageName:" + packageName);
        AoriseLog.d("className:" + className);
        if (null == packageName || null == className) {
            AoriseLog.e("请配置首页跳转地址");
            return;
        }

        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setComponent(new ComponentName(packageName, className));

        Bundle bundle = new Bundle();
        bundle.putSerializable(AoriseConstant.TransportKey.BUNDLE_KEY, value);
        intent.putExtras(bundle);

        activity.startActivity(intent);
        activity.finish();
    }
}
