package cn.aorise.common.component.common;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;

import java.lang.reflect.Type;

import cn.aorise.common.component.network.entity.response.AccountInfo;
import cn.aorise.common.core.config.AoriseConstant;
import cn.aorise.common.core.module.network.APICallback;
import cn.aorise.common.core.ui.base.BaseActivity;
import cn.aorise.common.core.utils.assist.AoriseLog;
import cn.aorise.common.core.utils.assist.AoriseUtil;
import cn.aorise.common.core.utils.assist.DebugUtil;
import cn.aorise.common.core.utils.system.AppUtil;
import rx.Subscriber;

import static cn.aorise.common.component.login.AoriseLoginActivity.LOGIN_CLASS_NAME_KEY;
import static cn.aorise.common.component.login.AoriseLoginActivity.PACKAGE_NAME_KEY;

/**
 * Created by Administrator on 2015/11/6 0006.
 */
public class Utils {
    private static final String TAG = "common.Utils";

    /**
     * common
     **********************************************************************************************/


    /**
     * private
     **********************************************************************************************/

    /**
     * 创建联网请求mock模式
     *
     * @param activity
     * @param mockPath
     * @param aClass
     * @param callback
     * @param <T>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> Subscriber<T> mockSubscriber(BaseActivity activity, String mockPath, Class<T> aClass, APICallback<T> callback) {
        AoriseLog.i(TAG, "DebugUtil.isDebug() = " + DebugUtil.isDebug());
        return AoriseUtil.mockSubscriber(DebugUtil.isDebug(), activity, mockPath, aClass, callback);
    }

    /**
     * 创建联网请求mock模式
     *
     * @param activity
     * @param mockPath
     * @param typeOfT
     * @param callback
     * @param <T>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> Subscriber<T> mockSubscriber(BaseActivity activity, String mockPath, Type typeOfT, APICallback<T> callback) {
        AoriseLog.i(TAG, "DebugUtil.isDebug() = " + DebugUtil.isDebug());
        return AoriseUtil.mockSubscriber(DebugUtil.isDebug(), activity, mockPath, typeOfT, callback);
    }

    /**
     * 进入配置的首页
     *
     * @param activity    Activity上下文
     * @param accountInfo 登录后返回的账号信息
     */
    public static void gotoMainActivity(Activity activity, AccountInfo accountInfo) {
        String packageName = AppUtil.getAppSource(activity, PACKAGE_NAME_KEY);
        String className = AppUtil.getAppSource(activity, LOGIN_CLASS_NAME_KEY);
        AoriseLog.d("packageName:" + packageName);
        AoriseLog.d("className:" + className);
        if (null == packageName || null == className) {
            AoriseLog.e("请配置首页跳转地址");
            return;
        }

        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setComponent(new ComponentName(packageName, className));

        Bundle bundle = new Bundle();
        bundle.putString(AoriseConstant.AccountKey.USER_ACCOUNT,
                (null == accountInfo) ? "" : accountInfo.getAccount());
        bundle.putString(AoriseConstant.AccountKey.USER_ID,
                (null == accountInfo) ? "" : accountInfo.getId());
        bundle.putString(AoriseConstant.AccountKey.USER_SEX,
                (null == accountInfo) ? "" : accountInfo.getSex());
        intent.putExtras(bundle);

        activity.startActivity(intent);
        activity.finish();
    }
}
