/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model.deserializer;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.bson.types.ObjectId;

public class ObjectIdDeserializer
extends JsonDeserializer<ObjectId> {
    public ObjectId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node instanceof NullNode) {
            return null;
        }
        if (node instanceof TextNode) {
            return new ObjectId(node.asText());
        }
        if (node instanceof ObjectNode) {
            String id = node.get("$oid").asText();
            return new ObjectId(id);
        }
        throw new JsonParseException(p, "can not deserialize node to ObjectId : " + node);
    }
}

