/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model.deserializer;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;

public class LongDeserializer
extends JsonDeserializer<Long> {
    public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node instanceof NullNode) {
            return 0L;
        }
        if (node instanceof IntNode) {
            return node.asLong();
        }
        if (node instanceof FloatNode) {
            return node.asLong();
        }
        if (node instanceof DoubleNode) {
            return node.asLong();
        }
        if (node instanceof TextNode) {
            return Long.valueOf(node.asText());
        }
        if (node instanceof ObjectNode) {
            return Long.valueOf(node.get("$numberLong").asText());
        }
        throw new JsonParseException(p, "can not deserialize node to Long : " + node);
    }
}

