/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model.deserializer;

import cn.alphabets.light.Helper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;

public class DateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node instanceof NullNode) {
            return null;
        }
        if (node instanceof TextNode) {
            String dateStr = node.asText();
            try {
                if (dateStr.endsWith("Z")) {
                    return Helper.fromUTCString(dateStr);
                }
                TimeZone timeZone = this.getTimeZone(ctx);
                return Helper.fromSupportedString(dateStr, timeZone);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (node instanceof ObjectNode) {
            long timestamp = node.get("$date").asLong();
            return new Date(timestamp);
        }
        throw new JsonParseException(p, "can not deserialize node to Date: " + node);
    }

    private TimeZone getTimeZone(DeserializationContext ctx) {
        return ctx.getTimeZone();
    }
}

