/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model.datarider;

import cn.alphabets.light.Helper;
import cn.alphabets.light.exception.DataRiderException;
import cn.alphabets.light.model.datarider.DBParams;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;

public class TypeConvertor {
    private static final Logger logger = LoggerFactory.getLogger(TypeConvertor.class);
    private DBParams params;
    private Map<String, Function> typeConverts = new ConcurrentHashMap<String, Function>(){
        {
            this.put("string", o -> {
                if (o == null) {
                    return null;
                }
                return o.toString();
            });
            this.put("boolean", o -> {
                if (o == null) {
                    return null;
                }
                if (o instanceof Boolean) {
                    return o;
                }
                if ("1".equals(o) || "true".equals(o)) {
                    return true;
                }
                if ("0".equals(o) || "false".equals(o)) {
                    return false;
                }
                if (o.equals(1)) {
                    return true;
                }
                if (o.equals(0)) {
                    return false;
                }
                throw DataRiderException.ParameterUnsatisfied(o.toString() + " -> boolean");
            });
            this.put("number", o -> {
                if (o == null) {
                    return null;
                }
                if (o instanceof Number) {
                    return o;
                }
                if (o instanceof String) {
                    try {
                        String s = (String)o;
                        if (s.contains(".")) {
                            return Float.valueOf(Float.parseFloat(s));
                        }
                        return Long.parseLong(s);
                    }
                    catch (NumberFormatException e) {
                        throw DataRiderException.ParameterUnsatisfied(o.toString() + " -> number", e);
                    }
                }
                throw DataRiderException.ParameterUnsatisfied(o.toString() + " -> number");
            });
            this.put("date", o -> {
                if (o == null) {
                    return null;
                }
                if (o instanceof Date) {
                    return o;
                }
                if (o instanceof Long) {
                    return new Date((Long)o);
                }
                if (o instanceof String) {
                    try {
                        if (StringUtils.isBlank((CharSequence)((String)o))) {
                            return null;
                        }
                        if (((String)o).endsWith("Z")) {
                            return Helper.fromUTCString((String)o);
                        }
                        return Helper.fromSupportedString((String)o, TypeConvertor.this.params.getHandler().getTimeZone());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw DataRiderException.ParameterUnsatisfied(o.toString() + " -> date");
            });
            this.put("objectid", o -> {
                if (o == null) {
                    return null;
                }
                if (o instanceof ObjectId) {
                    return o;
                }
                if (o instanceof String) {
                    if (StringUtils.isEmpty((CharSequence)((String)o))) {
                        return null;
                    }
                    return new ObjectId((String)o);
                }
                throw DataRiderException.ParameterUnsatisfied(o.toString() + " -> objectid");
            });
            this.put("object", o -> o);
            this.put("array", o -> o);
        }
    };

    public TypeConvertor(DBParams params) {
        this.params = params;
    }

    public Object convert(String valueType, Object value) {
        if (Arrays.asList("string", "boolean", "number", "date", "objectid").contains(valueType) && value instanceof List) {
            return ((List)value).stream().map(item -> this.convert(valueType, item)).collect(Collectors.toList());
        }
        return this.typeConverts.get(valueType).apply(value);
    }
}

