/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model.datarider;

import cn.alphabets.light.Constant;
import cn.alphabets.light.Environment;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.db.mongo.Controller;
import cn.alphabets.light.db.mongo.Model;
import cn.alphabets.light.entity.ModBoard;
import cn.alphabets.light.entity.ModStructure;
import cn.alphabets.light.exception.DataRiderException;
import cn.alphabets.light.http.Context;
import cn.alphabets.light.model.ModCommon;
import cn.alphabets.light.model.Plural;
import cn.alphabets.light.model.datarider.DBParams;
import cn.alphabets.light.model.datarider.TypeConvertor;
import com.mongodb.client.model.Filters;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.bson.conversions.Bson;

public class DataRider {
    private static final Logger logger = LoggerFactory.getLogger(DataRider.class);
    private static final List<String> METHOD = Arrays.asList("", "add", "update", "remove", "list", "search", "get", "count");
    private Class<? extends ModCommon> clazz;
    private ModBoard board;

    public static DataRider ride(Class clazz) {
        DataRider dataRider = new DataRider();
        dataRider.clazz = clazz;
        return dataRider;
    }

    public static DataRider ride(ModBoard board) {
        DataRider dataRider = new DataRider();
        dataRider.board = board;
        String className = "Mod" + WordUtils.capitalize((String)board.getSchema());
        boolean usingLightEntity = Model.reserved.contains(board.getSchema()) || Constant.KIND_BOARD_SYSTEM_DATA_API.equals(board.getKind());
        String packageName = usingLightEntity ? "cn.alphabets.light.entity" : Environment.instance().getPackages() + ".entity";
        try {
            dataRider.clazz = Class.forName(packageName + "." + className);
        }
        catch (ClassNotFoundException e) {
            throw DataRiderException.EntityClassNotFound(packageName + "." + className, board);
        }
        return dataRider;
    }

    public <T extends ModCommon> T add(DBParams params) {
        return (T)((ModCommon)this.call("add", params));
    }

    public <T extends ModCommon> T get(DBParams params) {
        return (T)((ModCommon)this.call("get", params));
    }

    public <T extends ModCommon> Plural<T> list(DBParams params) {
        return (Plural)this.call("list", params);
    }

    public Long remove(DBParams params) {
        return (Long)this.call("remove", params);
    }

    public <T extends ModCommon> T update(DBParams params) {
        return (T)((ModCommon)this.call("update", params));
    }

    public Long count(DBParams params) {
        return (Long)this.call("count", params);
    }

    public <T extends ModCommon> Plural<T> search(DBParams params) {
        throw new UnsupportedOperationException("rider search");
    }

    public Object call(String boardMethod, DBParams params) throws DataRiderException {
        if (this.board != null) {
            logger.warn((Object)"The board is exist , arg 'boardName' will be ignored");
        } else {
            this.board = DataRider.getBoard(this.clazz, boardMethod);
        }
        return this.call(params);
    }

    public Object call(DBParams params) throws DataRiderException {
        if (this.board == null) {
            throw DataRiderException.BoardNotFound("unknown api");
        }
        Object result = this.callCtrl(this.board, params);
        result = this.options(params.getHandler(), result, this.board);
        return result;
    }

    private Object options(Context handler, Object result, ModBoard board) {
        if (result instanceof ModCommon || result instanceof Plural) {
            ArrayList optionsBuilders = new ArrayList();
            board.getSelects().forEach(select -> {
                if (select.getSelect().booleanValue() && StringUtils.isNotEmpty((CharSequence)select.getOption())) {
                    optionsBuilders.add(new OptionsBuilder(select.getKey(), select.getFields(), select.getLink(), select.getOption()));
                }
            });
            HashMap<String, HashMap<String, ModCommon>> options = new HashMap<String, HashMap<String, ModCommon>>();
            optionsBuilders.stream().collect(Collectors.groupingBy(OptionsBuilder::getStructure)).forEach((s, optionsBuilders1) -> {
                OptionsBuilderGroup optionsBuilderGroup = new OptionsBuilderGroup((List<OptionsBuilder>)optionsBuilders1, (String)s);
                options.put((String)s, optionsBuilderGroup.build(handler, result));
            });
            if (result instanceof ModCommon) {
                ((ModCommon)result).setOptions(options.size() == 0 ? null : options);
            }
            if (result instanceof Plural) {
                ((Plural)result).setOptions(options.size() == 0 ? null : options);
            }
        }
        return result;
    }

    private Object callCtrl(ModBoard board, DBParams params) {
        params = params.adaptToBoard(this, board);
        Controller ctrl = new Controller(params);
        String methodName = METHOD.get(board.getType().intValue());
        try {
            Method method = ctrl.getClass().getMethod(methodName, new Class[0]);
            return method.invoke((Object)ctrl, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw DataRiderException.ControllerMethodCallFailed(methodName, e.getTargetException());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw DataRiderException.ControllerMethodCallFailed(methodName, e);
        }
    }

    private static ModBoard getBoard(Class<? extends ModCommon> clazz, String method) {
        String api = String.format("/api/%s/%s", WordUtils.uncapitalize((String)clazz.getSimpleName().replace("Mod", "")), method);
        for (ModBoard board : CacheManager.INSTANCE.getBoards()) {
            if (!board.getApi().toLowerCase().equals(api.toLowerCase())) continue;
            return board;
        }
        throw DataRiderException.BoardNotFound(api);
    }

    public Class<? extends ModCommon> getClazz() {
        return this.clazz;
    }

    static class OptionsBuilderGroup {
        private List<OptionsBuilder> list;
        private String structure;

        public OptionsBuilderGroup(List<OptionsBuilder> list, String structure) {
            this.list = list;
            this.structure = structure;
        }

        public HashMap<String, ModCommon> build(Context handler, Object result) {
            HashMap<String, ModCommon> option = new HashMap<String, ModCommon>();
            List<HashMap> results = this.list.stream().map(qb -> qb.build(handler, result)).collect(Collectors.toList());
            results.forEach(option::putAll);
            return option;
        }
    }

    static class OptionsBuilder {
        private String key;
        private List<String> field;
        private String link;
        private String structure;

        public OptionsBuilder(String key, List<String> field, String link, String structure) {
            this.key = key;
            this.field = field;
            this.link = link;
            this.structure = structure;
        }

        public HashMap<String, ModCommon> build(Context handler, Object result) {
            Bson condition;
            String table;
            ModStructure modStructure = CacheManager.INSTANCE.getStructures().stream().filter(s -> s.getSchema().equals(this.structure)).findFirst().get();
            HashMap<String, ModCommon> option = new HashMap<String, ModCommon>();
            TypeConvertor convertor = new TypeConvertor(new DBParams(handler));
            String valueType = ((HashMap)((HashMap)modStructure.getItems()).get(this.link)).get("type").toString().trim().toLowerCase();
            ArrayList<Object> fieldValues = new ArrayList<Object>();
            if (result instanceof ModCommon) {
                Object value = ((ModCommon)result).getFieldValue(this.key);
                Object converted = convertor.convert(valueType, value);
                if (converted instanceof List) {
                    fieldValues.addAll((Collection)convertor.convert(valueType, value));
                } else {
                    fieldValues.add(convertor.convert(valueType, value));
                }
            } else if (result instanceof Plural) {
                ((Plural)result).getItems().forEach(item -> {
                    Object value = ((ModCommon)item).getFieldValue(this.key);
                    Object converted = convertor.convert(valueType, value);
                    if (converted instanceof List) {
                        fieldValues.addAll((Collection)convertor.convert(valueType, value));
                    } else {
                        fieldValues.add(convertor.convert(valueType, value));
                    }
                });
            } else {
                return option;
            }
            fieldValues.removeAll(Collections.singleton(null));
            if (fieldValues.size() == 0) {
                return option;
            }
            if (modStructure.getKind() == 1L) {
                table = DBParams.extendType.get(modStructure.getType());
                condition = Filters.and((Bson[])new Bson[]{Filters.in((String)this.link, fieldValues), Filters.eq((String)"type", (Object)this.structure)});
            } else {
                table = this.structure;
                condition = Filters.in((String)this.link, fieldValues);
            }
            Class clazz = Model.getModelType(this.structure);
            Model model = new Model(handler.getDomain(), handler.getCode(), table, clazz);
            model.list(condition, this.field).forEach(item -> option.put(item.toDocument(true).get((Object)this.link).toString(), (ModCommon)item));
            return option;
        }

        public String getStructure() {
            return this.structure;
        }
    }
}

