/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model.datarider;

import cn.alphabets.light.Constant;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.entity.ModBoard;
import cn.alphabets.light.entity.ModStructure;
import cn.alphabets.light.exception.DataRiderException;
import cn.alphabets.light.http.Context;
import cn.alphabets.light.job.JobContext;
import cn.alphabets.light.model.ModCommon;
import cn.alphabets.light.model.datarider.DataRider;
import cn.alphabets.light.model.datarider.TypeConvertor;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class DBParams {
    private static final Logger logger = LoggerFactory.getLogger(DBParams.class);
    public static HashMap<Long, String> extendType = new HashMap<Long, String>(){
        {
            this.put(1L, "user");
            this.put(2L, "group");
            this.put(3L, "file");
            this.put(4L, "category");
        }
    };
    private Document condition;
    private Document select;
    private Document sort;
    private Document data;
    private int skip;
    private int limit;
    private String table;
    private Class<? extends ModCommon> clazz;
    private Context handler;

    public DBParams(Context aHandler) {
        this(aHandler, false);
    }

    public DBParams(Context aHandler, boolean attach) {
        this.handler = aHandler;
        if (attach) {
            if (aHandler instanceof JobContext) {
                throw DataRiderException.ParameterUnsatisfied("[JobContext can not be attach to DBParams]");
            }
            try {
                String limit;
                Document json = this.handler.params.getJson();
                if (json.containsKey((Object)"free")) {
                    this.condition = new Document("free", json.get((Object)"free"));
                } else {
                    Document condition = new Document();
                    if (json.containsKey((Object)"id")) {
                        condition.append("_id", (Object)new ObjectId(json.getString((Object)"id")));
                    }
                    if (json.containsKey((Object)"condition")) {
                        condition.putAll((Map)((Document)json.get((Object)"condition")));
                    }
                    this.condition = condition;
                }
                this.select = (Document)json.get((Object)"select");
                this.sort = (Document)json.get((Object)"sort");
                this.data = (Document)json.get((Object)"data");
                String skip = json.getString((Object)"skip");
                if (StringUtils.isNotEmpty((CharSequence)skip)) {
                    try {
                        this.skip = Integer.parseInt(skip);
                    }
                    catch (NumberFormatException e) {
                        logger.warn((Object)"error get [skip] ,use default 0", (Throwable)e);
                        this.skip = 0;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(limit = json.getString((Object)"limit")))) {
                    try {
                        this.limit = Integer.parseInt(limit);
                    }
                    catch (NumberFormatException e) {
                        logger.warn((Object)"error get [limit] ,use default 0", (Throwable)e);
                        this.limit = 0;
                    }
                }
            }
            catch (Exception e) {
                throw DataRiderException.ParameterUnsatisfied("[Handler]", e);
            }
        }
    }

    public DBParams condition(Document condition) {
        this.condition = condition;
        return this;
    }

    public DBParams select(Document select) {
        this.select = select;
        return this;
    }

    public DBParams sort(Document sort) {
        this.sort = sort;
        return this;
    }

    public DBParams data(Document data) {
        this.data = data;
        return this;
    }

    public DBParams data(ModCommon data) {
        this.data = data.toDocument();
        return this;
    }

    public DBParams skip(int skip) {
        this.skip = skip;
        return this;
    }

    public DBParams limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Document getCondition() {
        if (this.condition == null) {
            this.condition = new Document();
        }
        return this.condition;
    }

    public Document getSelect() {
        return this.select;
    }

    public Document getSort() {
        return this.sort;
    }

    public Document getData() {
        if (this.data == null) {
            this.data = new Document();
        }
        return this.data;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getDomain() {
        return this.handler.getDomain();
    }

    public String getCode() {
        return this.handler.getCode();
    }

    public Class<? extends ModCommon> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<? extends ModCommon> clazz) {
        this.clazz = clazz;
    }

    public String getUid() {
        return this.handler.uid();
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Context getHandler() {
        return this.handler;
    }

    public DBParams adaptToBoard(DataRider rider, ModBoard board) {
        ModStructure structure = CacheManager.INSTANCE.getStructures().stream().filter(s -> s.getSchema().equals(board.getSchema())).findFirst().get();
        this.buildSelect(board);
        this.buildCondition(board, structure);
        this.buildSort(board);
        if (structure.getKind() == 1L) {
            this.table = extendType.get(structure.getType());
            this.condition.append("type", (Object)structure.getSchema());
        } else {
            this.table = rider.getClazz().getSimpleName().replace("Mod", "").toLowerCase();
        }
        this.clazz = rider.getClazz();
        return this;
    }

    private void buildCondition(ModBoard board, ModStructure structure) {
        if (this.condition == null) {
            this.condition = new Document("valid", (Object)Constant.VALID);
        } else if (this.condition.containsKey((Object)"free")) {
            this.condition = (Document)this.condition.get((Object)"free");
        } else if (this.condition.containsKey((Object)"_id")) {
            this.condition = new Document().append("_id", this.condition.get((Object)"_id")).append("valid", (Object)Constant.VALID);
        } else {
            TypeConvertor convertor = new TypeConvertor(this);
            ArrayList conditionOr = new ArrayList();
            Map<String, List<ModBoard.Filters>> grouped = board.getFilters().stream().collect(Collectors.groupingBy(ModBoard.Filters::getGroup));
            grouped.forEach((s, filters) -> {
                Document section = new Document();
                filters.forEach(filter -> {
                    String parameter = filter.getKey();
                    String key = filter.getParameter();
                    Object reservedValue = this.reserved(key);
                    if (reservedValue != null) {
                        section.put(parameter, reservedValue);
                    } else if (this.condition.containsKey((Object)key)) {
                        Object value = this.condition.get((Object)key);
                        String valueType = this.detectValueType(structure, parameter);
                        if (section.containsKey((Object)parameter)) {
                            ((Document)section.get((Object)parameter)).put(filter.getOperator(), convertor.convert(valueType, value));
                        } else {
                            section.put(parameter, (Object)new Document(filter.getOperator(), convertor.convert(valueType, value)));
                        }
                    }
                });
                if (section.size() > 0) {
                    conditionOr.add(section);
                }
            });
            this.condition = new Document();
            if (conditionOr.size() == 1) {
                this.condition = (Document)conditionOr.get(0);
            } else if (conditionOr.size() > 1) {
                this.condition.put("$or", conditionOr);
            }
            this.condition.put("valid", (Object)Constant.VALID);
        }
    }

    private String detectValueType(ModStructure structure, String parameter) {
        if (parameter.contains(".")) {
            String[] array = parameter.split("\\.");
            HashMap subTypeInfo = (HashMap)((HashMap)((HashMap)structure.getItems()).get(array[0])).get("contents");
            return ((HashMap)subTypeInfo.get(array[1])).get("type").toString().toLowerCase();
        }
        return ((HashMap)((HashMap)structure.getItems()).get(parameter)).get("type").toString().trim().toLowerCase();
    }

    private void buildSelect(ModBoard board) {
        if (this.select != null) {
            Document confirmed = new Document();
            this.select.forEach((s, o) -> confirmed.put(s, o instanceof String ? Integer.valueOf(Integer.parseInt((String)o)) : o));
            this.select = confirmed;
        } else {
            this.select = new Document();
            board.getSelects().forEach(s -> {
                if (s.getSelect().booleanValue()) {
                    this.select.put(s.getKey(), (Object)1);
                }
            });
        }
    }

    private void buildSort(ModBoard board) {
        if (this.sort != null) {
            Document confirmed = new Document();
            this.sort.forEach((s, o) -> confirmed.put(s, o instanceof String ? Integer.valueOf(Integer.parseInt((String)o)) : o));
            this.sort = confirmed;
        } else {
            this.sort = new Document();
            board.getSorts().forEach(s -> this.sort.put(s.getKey(), (Object)("desc".equals(s.getOrder()) ? -1 : 1)));
        }
    }

    private Object reserved(String keyword) {
        if ("$uid".equals(keyword)) {
            return this.getUid();
        }
        if ("$corp".equals(keyword)) {
            return this.getCode();
        }
        if ("$sysdate".equals(keyword)) {
            return new Date();
        }
        if ("$systime".equals(keyword)) {
            return new Date();
        }
        return null;
    }

    public String toString() {
        return "\n{\n\ttable = " + this.getTable() + "\n\tclass = " + (this.clazz == null ? "null" : this.clazz.getName()) + "\n\tcondition = " + (this.condition == null ? "null" : this.condition.toJson()) + "\n\tselect = " + (this.select == null ? "null" : this.select.toJson()) + "\n\tsort = " + (this.sort == null ? "null" : this.sort.toJson()) + "\n\tdata = " + (this.data == null ? "null" : this.data.toJson()) + "\n\tskip = " + this.skip + "\n\tlimit = " + this.limit + "\n\tuid = " + this.getUid() + "\n\tdoamin = " + this.getDomain() + "\n\tcode = " + this.getCode() + "\n}";
    }
}

