/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model;

import cn.alphabets.light.Environment;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.db.mongo.Model;
import cn.alphabets.light.entity.ModCategory;
import cn.alphabets.light.entity.ModFile;
import cn.alphabets.light.entity.ModGroup;
import cn.alphabets.light.entity.ModUser;
import cn.alphabets.light.model.Entity;
import cn.alphabets.light.model.ModCommon;
import cn.alphabets.light.model.deserializer.DateDeserializer;
import cn.alphabets.light.model.deserializer.LongDeserializer;
import cn.alphabets.light.model.deserializer.ObjectIdDeserializer;
import cn.alphabets.light.model.serializer.DateSerializer;
import cn.alphabets.light.model.serializer.ObjectIdSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.text.WordUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class Generator {
    private String packageName;
    private static final Map<String, Type> types = new ConcurrentHashMap<String, Type>(){
        {
            this.put("string", String.class);
            this.put("date", Date.class);
            this.put("int", Integer.class);
            this.put("number", Long.class);
            this.put("array", List.class);
            this.put("boolean", Boolean.class);
            this.put("objectid", ObjectId.class);
            this.put("object", Object.class);
        }
    };
    private static final List<Type> structureType = Arrays.asList(ModCommon.class, ModUser.class, ModGroup.class, ModFile.class, ModCategory.class);
    private static final List<String> lightReserved = Arrays.asList("_id", "createAt", "updateAt", "createBy", "updateBy", "valid", "options");
    public static final List<String> reserved = Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    public Generator(String packageName) {
        this.packageName = packageName;
    }

    public void generate(String domain, List<String> schema) {
        Model model = new Model(domain, "light", "structure");
        Document condition = new Document("valid", (Object)1);
        condition.put("schema", (Object)new Document("$in", schema));
        List<Document> defines = model.document(condition, Arrays.asList("schema", "items", "type"));
        defines.forEach(define -> {
            TypeSpec.Builder builder = this.mainClass(define.getString((Object)"schema"), define.getInteger((Object)"type"));
            Document items = (Document)define.get((Object)"items");
            items.entrySet().forEach(item -> {
                if (!this.isParentField((String)item.getKey(), define.getInteger((Object)"type")) && !lightReserved.contains(item.getKey())) {
                    this.subClass(builder, (String)item.getKey(), (Document)item.getValue());
                }
            });
            this.write(builder.build());
        });
    }

    public void generate() {
        ArrayList<String> schemas = new ArrayList<String>();
        CacheManager.INSTANCE.getStructures().forEach(structure -> {
            if (structure.getKind() != 2L) {
                schemas.add(structure.getSchema());
            }
        });
        this.generate(Environment.instance().getAppName(), schemas);
    }

    private boolean isParentField(String name, Integer type) {
        if (type > 0) {
            for (Field field : ((Class)structureType.get(type)).getDeclaredFields()) {
                if (!field.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void write(TypeSpec type) {
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)type).build();
        try {
            javaFile.writeTo(new File("src/main/java"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TypeSpec.Builder mainClass(String className, Integer type) {
        return TypeSpec.classBuilder((String)("Mod" + WordUtils.capitalize((String)className))).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(TypeName.get((Type)structureType.get(type))).addJavadoc("Generated by the Light platform. Do not manually modify the code.\n", new Object[0]);
    }

    private void subClass(TypeSpec.Builder spec, String name, Document define) {
        Type type = Generator.regular(define.getString((Object)"type"));
        if (type != List.class && type != Object.class) {
            this.append(spec, name, this.type(type));
            return;
        }
        Document items = (Document)define.get((Object)"contents");
        if (items == null || items.isEmpty()) {
            this.append(spec, name, this.type(type));
            return;
        }
        this.append(spec, name, this.type(define.getString((Object)"type"), WordUtils.capitalize((String)name)));
        AnnotationSpec annotation = AnnotationSpec.builder(JsonIgnoreProperties.class).addMember("ignoreUnknown", "$L", new Object[]{Boolean.TRUE}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)WordUtils.capitalize((String)name)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).superclass(Entity.class).addAnnotation(annotation);
        items.entrySet().forEach(item -> this.subClass(builder, (String)item.getKey(), (Document)item.getValue()));
        spec.addType(builder.build());
    }

    private TypeName type(Type name) {
        return TypeName.get((Type)name);
    }

    private TypeName type(String name, String template) {
        Type type = Generator.regular(name);
        if (type == Object.class && template != null) {
            return ClassName.get((String)"", (String)template, (String[])new String[0]);
        }
        if (type == List.class && template != null) {
            return ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)template, (String[])new String[0])});
        }
        return TypeName.get((Type)type);
    }

    private void append(TypeSpec.Builder builder, String name, TypeName type) {
        builder.addField(this.field(name, type));
        builder.addMethod(this.getter(name, type));
        builder.addMethod(this.setter(name, type));
    }

    private FieldSpec field(String name, TypeName type) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)type, (String)(reserved.contains(name) ? name + "_" : name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (reserved.contains(name)) {
            builder.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{name}).build());
        }
        if (type.equals((Object)TypeName.get(Long.class))) {
            builder.addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("using", "$T.$L", new Object[]{LongDeserializer.class, "class"}).build());
        }
        if (type.equals((Object)TypeName.get(ObjectId.class))) {
            builder.addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("using", "$T.$L", new Object[]{ObjectIdDeserializer.class, "class"}).build());
            builder.addAnnotation(AnnotationSpec.builder(JsonSerialize.class).addMember("using", "$T.$L", new Object[]{ObjectIdSerializer.class, "class"}).build());
        }
        if (type.equals((Object)TypeName.get(Date.class))) {
            builder.addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("using", "$T.$L", new Object[]{DateDeserializer.class, "class"}).build());
            builder.addAnnotation(AnnotationSpec.builder(JsonSerialize.class).addMember("using", "$T.$L", new Object[]{DateSerializer.class, "class"}).build());
        }
        return builder.build();
    }

    private MethodSpec getter(String name, TypeName type) {
        String reservedName = reserved.contains(name) ? name + "_" : name;
        return MethodSpec.methodBuilder((String)("get" + WordUtils.capitalize((String)reservedName))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(type).addStatement(String.format("return this.%s", reservedName), new Object[0]).build();
    }

    private MethodSpec setter(String name, TypeName type) {
        String reservedName = reserved.contains(name) ? name + "_" : name;
        return MethodSpec.methodBuilder((String)("set" + WordUtils.capitalize((String)reservedName))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(type, reservedName, new Modifier[0]).addStatement(String.format("this.%s = %s", reservedName, reservedName), new Object[0]).build();
    }

    static Type regular(String type) {
        if (types.containsKey(type = type.toLowerCase().trim())) {
            return types.get(type);
        }
        return String.class;
    }
}

