/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model;

import cn.alphabets.light.Helper;
import cn.alphabets.light.db.mongo.Controller;
import cn.alphabets.light.entity.ModFile;
import cn.alphabets.light.exception.BadRequestException;
import cn.alphabets.light.exception.LightException;
import cn.alphabets.light.http.Context;
import cn.alphabets.light.http.RequestFile;
import cn.alphabets.light.model.Plural;
import cn.alphabets.light.model.datarider.DBParams;
import cn.alphabets.light.model.datarider.DataRider;
import com.mongodb.client.gridfs.model.GridFSFile;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class File {
    private static final Logger logger = LoggerFactory.getLogger(File.class);

    public Plural<ModFile> add(Context handler) throws BadRequestException {
        List<RequestFile> files = handler.params.getFiles();
        if (files == null) {
            throw new BadRequestException("No file content found.");
        }
        ArrayList result = new ArrayList();
        files.forEach(file -> {
            GridFSFile gfsFile = new Controller(new DBParams(handler)).writeFileToGrid((RequestFile)((Object)file));
            ModFile info = new ModFile();
            info.setName(gfsFile.getFilename());
            info.setLength(gfsFile.getLength());
            info.setContentType(gfsFile.getMetadata().getString((Object)"contentType"));
            info.setFileId(gfsFile.getObjectId());
            ModFile saved = (ModFile)DataRider.ride(ModFile.class).add(new DBParams(handler).data(info));
            if (!file.isKeep().booleanValue()) {
                new java.io.File(file.getFilePath()).delete();
            }
            logger.debug((Object)("file upload done : " + saved.toDocument().toJson()));
            result.add(saved);
        });
        return new Plural<ModFile>(Long.valueOf(result.size()), result);
    }

    public long remove(Context handler) throws LightException {
        ModFile info = (ModFile)DataRider.ride(ModFile.class).get(new DBParams(handler, true));
        if (info == null) {
            throw new BadRequestException("File not exist.");
        }
        logger.warn((Object)info.toDocument().toString());
        try {
            ObjectId fileId = info.getFileId();
            Controller ctrl = new Controller(new DBParams(handler).condition(new Document("_id", (Object)fileId)));
            ctrl.deleteFromGrid();
        }
        catch (Exception e) {
            logger.error((Object)"File content delete failed : ", (Throwable)e);
            throw new BadRequestException("File content delete failed.");
        }
        return DataRider.ride(ModFile.class).remove(new DBParams(handler, true));
    }

    public void image(Context handler) throws LightException {
        try {
            ModFile file = (ModFile)DataRider.ride(ModFile.class).get(new DBParams(handler, true));
            this.sendFile(handler, file);
        }
        catch (Exception e) {
            logger.error((Object)"error read file : ", (Throwable)e);
            throw new BadRequestException("File not exist.");
        }
    }

    public void saveFile(Context handler, ModFile file) {
        Controller ctrl = new Controller(new DBParams(handler).condition(new Document("_id", (Object)file.getFileId())));
        try {
            FileOutputStream outputStream = new FileOutputStream(file.getPath());
            ctrl.readStreamFromGrid(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            logger.error((Object)"error read file : ", (Throwable)e);
            throw new RuntimeException("File not exist.");
        }
    }

    public void sendFile(Context handler, ModFile file) {
        long offset;
        long end;
        Controller ctrl;
        block7: {
            String range = handler.req().getHeader("Range");
            ctrl = new Controller(new DBParams(handler).condition(new Document("_id", (Object)file.getFileId())));
            if (StringUtils.isEmpty((CharSequence)range)) {
                ByteArrayOutputStream content = ctrl.readStreamFromGrid();
                handler.res().putHeader(HttpHeaders.ACCEPT_RANGES, (CharSequence)"bytes").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)file.getContentType()).putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(file.getLength())).putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"public, max-age=34560000").putHeader(HttpHeaders.LAST_MODIFIED, (CharSequence)Helper.toUTCString(file.getUpdateAt())).write(Buffer.buffer((byte[])content.toByteArray())).end();
                return;
            }
            Pattern patternRange = Pattern.compile("^bytes=(\\d+)-(\\d*)$");
            end = file.getLength() - 1L;
            offset = -1L;
            Matcher m = patternRange.matcher(range);
            try {
                if (m.matches()) {
                    String part = m.group(1);
                    offset = Long.parseLong(part);
                    if (offset < 0L || offset >= file.getLength()) {
                        throw new IndexOutOfBoundsException();
                    }
                    part = m.group(2);
                    if (part != null && part.length() > 0 && ((end = Long.parseLong(part)) < offset || end >= file.getLength())) {
                        throw new IndexOutOfBoundsException();
                    }
                    break block7;
                }
                throw new IndexOutOfBoundsException();
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                handler.res().putHeader("Content-Range", "bytes */" + file.getLength()).setStatusCode(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code()).end(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.reasonPhrase());
            }
        }
        offset = Math.max(offset, 0L);
        handler.res().putHeader(HttpHeaders.ACCEPT_RANGES, (CharSequence)"bytes").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)file.getContentType()).putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(end + 1L - offset)).putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"public, max-age=34560000").putHeader(HttpHeaders.LAST_MODIFIED, (CharSequence)Helper.toUTCString(file.getUpdateAt()));
        if (handler.req().method() == HttpMethod.HEAD) {
            handler.res().end();
            return;
        }
        ByteArrayOutputStream content = ctrl.readStreamFromGrid(offset, end - offset + 1L);
        handler.res().putHeader(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes " + offset + "-" + end + "/" + file.getLength())).setStatusCode(HttpResponseStatus.PARTIAL_CONTENT.code()).write(Buffer.buffer((byte[])content.toByteArray())).end();
    }
}

