/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.model;

import cn.alphabets.light.http.Context;
import cn.alphabets.light.model.Generator;
import cn.alphabets.light.model.ModCommon;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bson.Document;

@JsonPropertyOrder(alphabetic=true)
public class Entity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private static final Logger logger = LoggerFactory.getLogger(Entity.class);
    @JsonIgnore
    private static ObjectMapper objectMapper = new ObjectMapper();
    @JsonIgnore
    private static ConcurrentHashMap<TimeZone, ObjectMapper> objectMappers = new ConcurrentHashMap();

    private List<?> parseList(List<?> list) {
        return list.stream().map(x -> {
            if (x instanceof Entity) {
                return ((Entity)x).toDocument();
            }
            if (x instanceof List) {
                return this.parseList((List)x);
            }
            return x;
        }).collect(Collectors.toList());
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean ignoreNullValue) {
        ConcurrentHashMap<String, PropertyDescriptor> properties = new ConcurrentHashMap<String, PropertyDescriptor>();
        Entity.getProperties(this.getClass(), properties);
        Document document = new Document();
        properties.forEach((key, property) -> {
            try {
                Document val = property.getReadMethod().invoke((Object)this, new Object[0]);
                if (val instanceof List) {
                    val = this.parseList((List)val);
                }
                if (val instanceof Entity) {
                    val = ((Entity)val).toDocument();
                }
                if (!ignoreNullValue || val != null) {
                    document.put(key, (Object)val);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        });
        return document;
    }

    private static void getProperties(Class clazz, Map<String, PropertyDescriptor> properties) {
        Arrays.stream(clazz.getDeclaredFields()).forEach(x -> {
            try {
                if (Modifier.isStatic(x.getModifiers())) {
                    return;
                }
                String key = x.getName();
                for (Annotation annotation : x.getDeclaredAnnotations()) {
                    if (!(annotation instanceof JsonProperty)) continue;
                    JsonProperty jp = (JsonProperty)annotation;
                    if (jp.access() == JsonProperty.Access.READ_ONLY) {
                        return;
                    }
                    key = jp.value();
                }
                properties.put(key, new PropertyDescriptor(x.getName(), clazz));
            }
            catch (IntrospectionException e) {
                logger.warn((Object)e);
            }
        });
        if (clazz.getSuperclass() != Object.class) {
            Entity.getProperties(clazz.getSuperclass(), properties);
        }
    }

    public static <T extends ModCommon> T fromDocument(Document document, Class<T> clazz) {
        if (document == null) {
            return null;
        }
        try {
            return (T)((ModCommon)objectMapper.readValue(document.toJson(), clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends ModCommon> T fromDocument(Document document, Class<T> clazz, Context handler) {
        if (document == null) {
            return null;
        }
        try {
            TimeZone tz = handler.getTimeZone();
            ObjectMapper mapper = objectMappers.get(tz);
            if (mapper == null) {
                mapper = new ObjectMapper();
                mapper.setTimeZone(tz);
                objectMappers.put(tz, mapper);
            }
            return (T)((ModCommon)mapper.readValue(document.toJson(), clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnore
    public Object getFieldValue(String fieldName) {
        try {
            String[] fields = fieldName.split("\\.");
            Object step = this;
            for (String f : Arrays.asList(fields)) {
                if (step == null) {
                    return step;
                }
                PropertyDescriptor pd = new PropertyDescriptor(Generator.reserved.contains(f) ? f + "_" : f, step.getClass());
                step = pd.getReadMethod().invoke(step, new Object[0]);
            }
            return step;
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error((Object)("Error get field value : " + fieldName), (Throwable)e);
            return null;
        }
    }
}

