/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.job;

import cn.alphabets.light.Environment;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.entity.ModJob;
import cn.alphabets.light.job.JobExecutor;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class JobManager {
    private static final Logger logger = LoggerFactory.getLogger(JobManager.class);

    public static void start() {
        if (!Environment.instance().app.isMaster()) {
            return;
        }
        try {
            logger.info((Object)"Jobs starting ...");
            int pollSize = CacheManager.INSTANCE.getJobs().size() + 1;
            Properties properties = new Properties();
            properties.setProperty("org.quartz.threadPool.threadCount", String.valueOf(pollSize));
            properties.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory(properties);
            Scheduler scheduler = stdSchedulerFactory.getScheduler();
            scheduler.start();
            for (ModJob job : CacheManager.INSTANCE.getJobs()) {
                if (!"STARTED".equals(job.getRun())) continue;
                JobExecutor jobExecutor = new JobExecutor(job);
                scheduler.scheduleJob(jobExecutor.getDetail(), jobExecutor.getTrigger());
            }
            logger.info((Object)"Jobs started .");
        }
        catch (Exception e) {
            logger.error((Object)"Jobs start failed : ", (Throwable)e);
        }
    }
}

