/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.job;

import cn.alphabets.light.Environment;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.config.ConfigManager;
import cn.alphabets.light.db.mongo.Model;
import cn.alphabets.light.entity.ModJob;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.text.WordUtils;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class JobExecutor
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(JobExecutor.class);
    private JobDetail detail;
    private Trigger trigger;

    public JobExecutor() {
    }

    public JobExecutor(ModJob job) {
        this.trigger = TriggerBuilder.newTrigger().withIdentity("trigger-" + job.get_id(), "light").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getSchedule()).inTimeZone(this.getTimeZone())).build();
        this.detail = JobBuilder.newJob(JobExecutor.class).withIdentity("job-" + job.get_id(), "light").usingJobData("jobId", job.get_id().toString()).build();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        ObjectId jobId = new ObjectId(dataMap.getString("jobId"));
        ModJob info = CacheManager.INSTANCE.getJobs().stream().filter(job -> job.get_id().equals((Object)jobId)).findFirst().get();
        logger.info((Object)String.format("Job [%s] executing start ...", jobId.toString()));
        List<ModJob.Step> steps = info.getStep();
        try {
            for (ModJob.Step step : steps) {
                this.executeStep(step);
            }
            this.setJobStatus(info, true);
        }
        catch (JobExecutionException e) {
            this.setJobStatus(info, false);
            throw e;
        }
    }

    private void executeStep(ModJob.Step step) throws JobExecutionException {
        if ("action".equals(step.getType())) {
            this.executeAction(step);
        } else {
            this.executeScript(step);
        }
    }

    private void executeScript(ModJob.Step step) throws JobExecutionException {
    }

    private void executeAction(ModJob.Step step) throws JobExecutionException {
        try {
            String clazz = step.getClass_();
            String fullName = Environment.instance().getPackages() + ".controller." + WordUtils.capitalize((String)clazz);
            Method method = Class.forName(fullName).getMethod(step.getAction(), HashMap.class);
            boolean result = (Boolean)method.invoke(method.getDeclaringClass().newInstance(), step.getParams());
            if (!result) {
                throw new JobExecutionException("Action method return false");
            }
        }
        catch (Exception e) {
            throw new JobExecutionException("Action method invoke by exception : ", (Throwable)e);
        }
    }

    private void setJobStatus(ModJob info, boolean success) {
        String status = success ? "COMPLETED" : "FAILED";
        Environment env = Environment.instance();
        String code = "light";
        try {
            new Model(env.getAppName(), code, "job").update(new Document("_id", (Object)info.get_id()), new Document("status", (Object)status).append("last", (Object)new Date()));
        }
        catch (Exception e) {
            logger.error((Object)"Error update job info", (Throwable)e);
        }
    }

    private TimeZone getTimeZone() {
        String conftz = ConfigManager.INSTANCE.getString("app.timezone");
        if (conftz != null) {
            return TimeZone.getTimeZone(conftz);
        }
        return TimeZone.getDefault();
    }

    public JobDetail getDetail() {
        return this.detail;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }
}

