/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http.session;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.SessionStore;

public class SessionHandlerImpl
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private static String DEFAULT_SESSION_COOKIE_NAME = "light.jsid";
    private static long DEFAULT_SESSION_TIMEOUT = 1800000L;
    private static boolean DEFAULT_NAG_HTTPS = true;
    private static boolean DEFAULT_COOKIE_HTTP_ONLY_FLAG = false;
    private static boolean DEFAULT_COOKIE_SECURE_FLAG = false;
    private final SessionStore sessionStore;
    private String sessionCookieName;
    private long sessionTimeout;
    private boolean nagHttps;
    private boolean sessionCookieSecure;
    private boolean sessionCookieHttpOnly;

    public SessionHandlerImpl(String sessionCookieName, long sessionTimeout, boolean nagHttps, boolean sessionCookieSecure, boolean sessionCookieHttpOnly, SessionStore sessionStore) {
        this.sessionCookieName = sessionCookieName;
        this.sessionTimeout = sessionTimeout;
        this.nagHttps = nagHttps;
        this.sessionStore = sessionStore;
        this.sessionCookieSecure = sessionCookieSecure;
        this.sessionCookieHttpOnly = sessionCookieHttpOnly;
    }

    public static SessionHandlerImpl create(SessionStore sessionStore) {
        return new SessionHandlerImpl(DEFAULT_SESSION_COOKIE_NAME, DEFAULT_SESSION_TIMEOUT, DEFAULT_NAG_HTTPS, DEFAULT_COOKIE_SECURE_FLAG, DEFAULT_COOKIE_HTTP_ONLY_FLAG, sessionStore);
    }

    public SessionHandler setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout;
        return this;
    }

    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.sessionCookieSecure = secure;
        return this;
    }

    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.sessionCookieHttpOnly = httpOnly;
        return this;
    }

    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    public void handle(RoutingContext context) {
        Cookie cookie;
        String uri;
        context.response().ended();
        if (this.nagHttps && !(uri = context.request().absoluteURI()).startsWith("https:")) {
            log.warn((Object)("Using session cookies without https could make you susceptible to session hijacking: " + uri));
        }
        if ((cookie = context.getCookie(this.sessionCookieName)) != null) {
            String sessionID = cookie.getValue();
            this.getSession(context.vertx(), sessionID, (Handler<AsyncResult<Session>>)((Handler)res -> {
                if (res.succeeded()) {
                    Session session = (Session)res.result();
                    if (session != null) {
                        context.setSession(session);
                        session.setAccessed();
                        this.addStoreSessionHandler(context);
                        this.refreshCookie(context, session);
                    } else {
                        this.createNewSession(context);
                    }
                } else {
                    context.fail(res.cause());
                }
                context.next();
            }));
        } else {
            this.createNewSession(context);
            context.next();
        }
    }

    private void getSession(Vertx vertx, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.doGetSession(vertx, System.currentTimeMillis(), sessionID, resultHandler);
    }

    private void doGetSession(Vertx vertx, long startTime, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.sessionStore.get(sessionID, res -> {
            long retryTimeout;
            if (res.succeeded() && res.result() == null && (retryTimeout = this.sessionStore.retryTimeout()) > 0L && System.currentTimeMillis() - startTime < retryTimeout) {
                vertx.setTimer(5L, v -> this.doGetSession(vertx, startTime, sessionID, resultHandler));
                return;
            }
            resultHandler.handle(res);
        });
    }

    private void addStoreSessionHandler(RoutingContext context) {
        context.addHeadersEndHandler(v -> {
            Session session = context.session();
            if (!session.isDestroyed()) {
                int currentStatusCode = context.response().getStatusCode();
                if (currentStatusCode >= 200 && currentStatusCode < 400) {
                    session.setAccessed();
                    this.sessionStore.put(session, res -> {
                        if (res.failed()) {
                            log.error((Object)"Failed to store session", res.cause());
                        }
                    });
                } else {
                    context.removeCookie(this.sessionCookieName);
                }
            } else {
                this.sessionStore.delete(session.id(), res -> {
                    if (res.failed()) {
                        log.error((Object)"Failed to delete session", res.cause());
                    }
                });
            }
        });
    }

    private void refreshCookie(RoutingContext context, Session session) {
        Cookie cookie = Cookie.cookie((String)this.sessionCookieName, (String)session.id());
        cookie.setPath("/");
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        cookie.setMaxAge(session.timeout() / 1000L);
        context.addCookie(cookie);
    }

    private void createNewSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout);
        context.setSession(session);
        Cookie cookie = Cookie.cookie((String)this.sessionCookieName, (String)session.id());
        cookie.setPath("/");
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        cookie.setMaxAge(session.timeout() / 1000L);
        context.addCookie(cookie);
        this.addStoreSessionHandler(context);
    }
}

