/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http.session;

import cn.alphabets.light.Environment;
import cn.alphabets.light.db.mongo.Connection;
import cn.alphabets.light.entity.ModUser;
import cn.alphabets.light.http.session.SessionImpl;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.ArrayList;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MongoSessionStoreImpl
implements SessionStore {
    private static final Logger log = LoggerFactory.getLogger(MongoSessionStoreImpl.class);
    private static final String SESSION_COLLECTION_NAME = "jsessions";
    private Vertx vertx;
    private MongoDatabase mongo;

    public MongoSessionStoreImpl(String domain, Vertx vertx) {
        MongoClient client = Connection.instance(Environment.instance());
        this.mongo = client.getDatabase(domain);
        this.vertx = vertx;
    }

    public long retryTimeout() {
        return 0L;
    }

    public Session createSession(long timeout) {
        return new SessionImpl(timeout);
    }

    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        Document doc = (Document)this.mongo.getCollection(SESSION_COLLECTION_NAME).find(Filters.eq((String)"_id", (Object)new ObjectId(id))).first();
        SessionImpl session = SessionImpl.fromDoc(doc);
        if (session != null && System.currentTimeMillis() - session.lastAccessed() > session.timeout()) {
            this.delete(session.id(), (Handler<AsyncResult<Boolean>>)((Handler)result -> {}));
            session = null;
        }
        resultHandler.handle((Object)Future.succeededFuture((Object)session));
    }

    public void delete(String id, Handler<AsyncResult<Boolean>> resultHandler) {
        DeleteResult result = this.mongo.getCollection(SESSION_COLLECTION_NAME).deleteOne((Bson)new Document("_id", (Object)new ObjectId(id)));
        resultHandler.handle((Object)Future.succeededFuture((Object)result.wasAcknowledged()));
    }

    public void put(Session session, Handler<AsyncResult<Boolean>> resultHandler) {
        ArrayList<Bson> updates = new ArrayList<Bson>();
        String raw = ((SessionImpl)session).toRawString();
        updates.add(Updates.set((String)"rawData", (Object)raw));
        ModUser user = (ModUser)((SessionImpl)session).get("_sk_user");
        if (user != null) {
            updates.add(Updates.set((String)"uid", (Object)user.getId()));
        }
        updates.add(Updates.set((String)"lastAccessed", (Object)session.lastAccessed()));
        updates.add(Updates.set((String)"timeoutMS", (Object)session.timeout()));
        updates.add(Updates.set((String)"isDestroyed", (Object)session.isDestroyed()));
        UpdateResult result = this.mongo.getCollection(SESSION_COLLECTION_NAME).updateOne((Bson)new Document("_id", (Object)new ObjectId(session.id())), Updates.combine(updates), new UpdateOptions().upsert(true));
        resultHandler.handle((Object)Future.succeededFuture((Object)result.wasAcknowledged()));
    }

    public void clear(Handler<AsyncResult<Boolean>> resultHandler) {
        this.mongo.getCollection(SESSION_COLLECTION_NAME).drop();
        resultHandler.handle((Object)Future.succeededFuture((Object)true));
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        int count = (int)this.mongo.getCollection(SESSION_COLLECTION_NAME).count();
        resultHandler.handle((Object)Future.succeededFuture((Object)count));
    }

    public void close() {
    }
}

