/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http;

import cn.alphabets.light.config.ConfigManager;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public interface TimeoutHandler
extends Handler<RoutingContext> {
    public static TimeoutHandler create(Long timeout) {
        return new TimeoutHandlerImpl(timeout);
    }

    public static class TimeoutHandlerImpl
    implements TimeoutHandler {
        private static final Logger log = LoggerFactory.getLogger(TimeoutHandlerImpl.class);
        private long timeout;
        private Pattern ignore;
        HttpResponseStatus errorStatus = HttpResponseStatus.SERVICE_UNAVAILABLE;

        TimeoutHandlerImpl(long timeout) {
            this.timeout = timeout;
            if (timeout <= 0L) {
                throw new IllegalArgumentException("time out can not be less than 0");
            }
            List<String> paths = ConfigManager.INSTANCE.getIgnoreTimeout();
            if (CollectionUtils.isNotEmpty(paths)) {
                String regex = StringUtils.join(paths, (String)"|");
                this.ignore = Pattern.compile(regex.replace("*", ".*"));
            }
        }

        public void handle(RoutingContext ctx) {
            String path = ctx.request().path();
            if (this.ignore != null && !this.ignore.matcher(path).matches()) {
                long tid = ctx.vertx().setTimer(this.timeout, t -> {
                    log.error((Object)("Request timeout : " + path));
                    ctx.response().setStatusCode(this.errorStatus.code()).end(this.errorStatus.reasonPhrase());
                });
                ctx.addBodyEndHandler(v -> ctx.vertx().cancelTimer(tid));
            }
            ctx.next();
        }
    }
}

