/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http;

import cn.alphabets.light.exception.LightException;
import cn.alphabets.light.model.Error;
import cn.alphabets.light.model.Views;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;

@JsonPropertyOrder(alphabetic=true)
public class Result {
    private Object data;
    private Error error;

    public Result(Object data) {
        if (data instanceof LightException) {
            LightException error = (LightException)data;
            this.error = new Error(error.getCode(), error.getMessage());
        } else if (data instanceof Error) {
            this.error = (Error)data;
        } else {
            this.data = data;
        }
    }

    public String getApiVersion() {
        return "1.0";
    }

    public Object getData() {
        return this.data;
    }

    public Error getError() {
        return this.error;
    }

    public String json() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return mapper.writerWithView(Views.OptionsView.class).writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void send(RoutingContext context) {
        HttpServerResponse response = context.response();
        response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8");
        response.end(this.json());
    }

    public static void redirect(RoutingContext context, String path) {
        HttpServerResponse response = context.response();
        response.putHeader("Location", path);
        response.setStatusCode(HttpResponseStatus.FOUND.code());
        response.end();
    }
}

