/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http;

import cn.alphabets.light.Constant;
import cn.alphabets.light.Environment;
import cn.alphabets.light.Helper;
import cn.alphabets.light.I18N;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.config.ConfigManager;
import cn.alphabets.light.entity.ModBoard;
import cn.alphabets.light.entity.ModRoute;
import cn.alphabets.light.exception.DataRiderException;
import cn.alphabets.light.exception.LightException;
import cn.alphabets.light.http.Context;
import cn.alphabets.light.http.Result;
import cn.alphabets.light.http.exception.MethodNotFoundException;
import cn.alphabets.light.http.exception.ProcessingException;
import cn.alphabets.light.model.Error;
import cn.alphabets.light.model.datarider.DBParams;
import cn.alphabets.light.model.datarider.DataRider;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.jtwig.functions.SimpleJtwigFunction;

public class Dispatcher {
    private static final Logger logger = LoggerFactory.getLogger(Dispatcher.class);
    private final List<ModBoard> boards;
    private final List<ModRoute> routes;
    private final Map<String, Method> methods;
    private final ConfigManager conf;
    private LinkedHashMap<Class, BiConsumer<RoutingContext, Throwable>> errorProcessMap = new LinkedHashMap<Class, BiConsumer<RoutingContext, Throwable>>(){
        {
            this.put(MethodNotFoundException.class, (ctx, e) -> {
                Error error = new Error("100", e.getMessage());
                ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").setStatusCode(520).end(new Result(error).json());
            });
            this.put(IllegalStateException.class, (ctx, e) -> {
                Error error = new Error("101", e.getMessage());
                ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").setStatusCode(520).end(new Result(error).json());
            });
            this.put(LightException.class, (ctx, e) -> {
                Result result = new Result(e);
                ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").setStatusCode(520).end(result.json());
            });
            this.put(DataRiderException.class, (ctx, e) -> {
                Error error = new Error("103", e.getMessage());
                ctx.response().setStatusCode(520).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").end(new Result(error).json());
            });
            this.put(ProcessingException.class, (ctx, e) -> {
                Throwable cause = e.getCause();
                if (cause == null) {
                    ((BiConsumer)Dispatcher.this.errorProcessMap.get(Throwable.class)).accept(ctx, null);
                    return;
                }
                Dispatcher.this.processException(ctx, cause);
            });
            this.put(Throwable.class, (ctx, e) -> {
                String msg;
                if (e == null) {
                    msg = "Unknown error.";
                } else {
                    msg = e.getMessage();
                    if (StringUtils.isEmpty((CharSequence)msg)) {
                        msg = e.toString();
                    }
                }
                Error error = new Error("000", msg);
                ctx.response().setStatusCode(520).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").end(new Result(error).json());
            });
        }
    };

    public Dispatcher() {
        this.boards = CacheManager.INSTANCE.getBoards();
        this.routes = CacheManager.INSTANCE.getRoutes();
        this.conf = ConfigManager.INSTANCE;
        this.methods = new ConcurrentHashMap<String, Method>();
    }

    public void routeProcessAPI(Router router) {
        this.boards.forEach(board -> {
            if (!Constant.KIND_BOARD_PROCESS_API.equals(board.getKind())) {
                return;
            }
            Route r = router.route(board.getApi());
            r.failureHandler(this.getFailureHandler());
            r.blockingHandler(ctx -> {
                Object data;
                String className = board.getClass_();
                String actionName = board.getAction();
                if (className == null || actionName == null) {
                    throw new MethodNotFoundException("Dispatch method not found.");
                }
                Method method = this.resolve(className, actionName);
                if (method == null) {
                    throw new MethodNotFoundException("Dispatch method not found.");
                }
                try {
                    data = method.invoke(method.getDeclaringClass().newInstance(), new Context((RoutingContext)ctx));
                }
                catch (InvocationTargetException e) {
                    throw new ProcessingException(e.getTargetException());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ProcessingException(e);
                }
                if (!method.getReturnType().equals(Void.TYPE)) {
                    new Result(data).send((RoutingContext)ctx);
                }
            }, false);
        });
    }

    public void routeDataAPI(Router router) {
        this.boards.forEach(board -> {
            if (!Constant.KIND_BOARD_SYSTEM_DATA_API.equals(board.getKind()) && !Constant.KIND_BOARD_DATA_API.equals(board.getKind())) {
                return;
            }
            Route r = router.route(board.getApi());
            r.failureHandler(this.getFailureHandler());
            r.blockingHandler(ctx -> {
                Context handler = new Context((RoutingContext)ctx);
                String className = board.getClass_();
                String actionName = board.getAction();
                if (className != null && actionName != null) {
                    Method method = this.resolve(className, actionName);
                    if (method == null) {
                        method = this.resolve(className, actionName, "cn.alphabets.light.model");
                    }
                    if (method != null) {
                        Object data;
                        try {
                            data = method.invoke(method.getDeclaringClass().newInstance(), handler);
                        }
                        catch (InvocationTargetException e) {
                            throw new ProcessingException(e.getTargetException());
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new ProcessingException(e);
                        }
                        if (!method.getReturnType().equals(Void.TYPE)) {
                            new Result(data).send((RoutingContext)ctx);
                        }
                        return;
                    }
                }
                Object data = DataRider.ride(board).call(new DBParams(handler, true));
                new Result(data).send((RoutingContext)ctx);
            }, false);
        });
    }

    public void routeView(Router router) {
        this.routes.forEach(route -> {
            Route r = router.route(route.getUrl());
            r.failureHandler(this.getFailureHandler());
            r.blockingHandler(ctx -> {
                String template;
                Object customized;
                final Context handler = new Context((RoutingContext)ctx);
                try {
                    customized = this.invoke((ModRoute)route, handler);
                }
                catch (InvocationTargetException e) {
                    throw new ProcessingException(e.getTargetException());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ProcessingException(e);
                }
                Helper.StringFunction i = new Helper.StringFunction("i", args -> {
                    String lang = handler.getLang();
                    String key = (String)args.get(0);
                    return I18N.i(lang, key);
                });
                Helper.MapFunction catalog = new Helper.MapFunction("catalog", args -> {
                    String lang = handler.getLang();
                    String type = (String)args.get(0);
                    return I18N.catalog(lang, type);
                });
                Helper.StringFunction dynamic = new Helper.StringFunction("dynamic", args -> {
                    String url = (String)args.get(0);
                    String stamp = this.conf.getString("app.stamp");
                    String prefix = this.conf.getString("app.static");
                    String connector = url.contains("?") ? "&" : "?";
                    return String.format("%s%s%sstamp=%s", prefix, url, connector, stamp);
                });
                ConcurrentHashMap<String, Object> model = new ConcurrentHashMap<String, Object>(){
                    {
                        this.put("req", handler.req());
                        this.put("handler", handler);
                        this.put("conf", Environment.instance());
                        this.put("csrftoken", ctx.get("X-XSRF-TOKEN"));
                    }
                };
                if (handler.user() != null) {
                    model.put("user", handler.user());
                }
                if (customized != null) {
                    model.put("data", customized);
                }
                if (!StringUtils.endsWith((CharSequence)(template = route.getTemplate()), (CharSequence)".html")) {
                    template = template + ".html";
                }
                String name = "views/" + template;
                String html = Helper.loadTemplate(name, (Map<String, Object>)model, Arrays.asList(new SimpleJtwigFunction[]{dynamic, i, catalog}));
                ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.TEXT_HTML).end(html);
            }, false);
        });
    }

    private Object invoke(ModRoute route, Context handler) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        String className = route.getClass_();
        String actionName = route.getAction();
        if (className == null || actionName == null) {
            return null;
        }
        Method method = this.resolve(className, actionName);
        if (method == null) {
            return null;
        }
        return method.invoke(method.getDeclaringClass().newInstance(), handler);
    }

    private Method resolve(String className, String methodName) {
        return this.resolve(className, methodName, Environment.instance().getPackages() + ".controller");
    }

    private Method resolve(String className, String methodName, String packages) {
        String fullName = packages + "." + WordUtils.capitalize((String)className);
        String key = String.format("%s#%s", fullName, methodName);
        if (!this.methods.containsKey(key)) {
            try {
                this.methods.put(key, Class.forName(fullName).getMethod(methodName, Context.class));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                return null;
            }
        }
        return this.methods.get(key);
    }

    private Handler<RoutingContext> getFailureHandler() {
        return ctx -> {
            if (ctx.response().ended()) {
                return;
            }
            Throwable error = ctx.failure();
            if (error == null && !ctx.response().ended()) {
                ctx.response().end();
            }
            logger.error((Object)"Error occurred : ", error);
            this.processException((RoutingContext)ctx, error);
        };
    }

    private void processException(RoutingContext ctx, Throwable error) {
        this.errorProcessMap.keySet().forEach(aClass -> {
            if (aClass.isAssignableFrom(error.getClass())) {
                if (ctx.response().ended()) {
                    return;
                }
                this.errorProcessMap.get(aClass).accept(ctx, error);
            }
        });
    }
}

