/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http;

import cn.alphabets.light.Environment;
import cn.alphabets.light.Helper;
import cn.alphabets.light.config.ConfigManager;
import cn.alphabets.light.entity.ModUser;
import cn.alphabets.light.http.Params;
import cn.alphabets.light.http.RequestFile;
import cn.alphabets.light.model.ModCommon;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class Context {
    private static final Logger logger = LoggerFactory.getLogger(Context.class);
    public final Params params;
    protected RoutingContext ctx;
    protected String domain;
    protected String code;
    protected String uid;

    protected Context() {
        this.params = null;
    }

    public Context(Params params, String domain, String code, String uid) {
        this.params = params;
        this.domain = domain;
        this.code = code;
        this.uid = uid;
    }

    public Context(RoutingContext ctx) {
        this(ctx, null, null);
    }

    public Context(RoutingContext ctx, String domain, String code) {
        this.ctx = ctx;
        this.domain = domain;
        this.code = code;
        Document parameter = new Document();
        if (ctx.pathParams().size() > 0) {
            parameter.putAll(ctx.pathParams());
        }
        if (ctx.request().uri().indexOf(63) > 0) {
            parameter.putAll((Map)Helper.unParam(ctx.request().uri()));
        }
        if (ctx.getBodyAsString().length() > 0) {
            parameter.putAll((Map)Document.parse((String)ctx.getBodyAsString()));
        }
        if (ctx.fileUploads().size() > 0) {
            Set uploads = ctx.fileUploads();
            List<RequestFile> files = uploads.stream().map(x -> {
                RequestFile file = new RequestFile("filename", x.fileName());
                file.put("content_type", x.contentType());
                file.put("file", x.uploadedFileName());
                return file;
            }).collect(Collectors.toList());
            this.params = new Params(parameter, files);
        } else {
            this.params = new Params(parameter);
        }
        logger.debug((Object)("req params : " + this.params.toString()));
    }

    public HttpServerResponse res() {
        return this.ctx.response();
    }

    public HttpServerRequest req() {
        return this.ctx.request();
    }

    public RoutingContext ctx() {
        return this.ctx;
    }

    public Session session() {
        return this.ctx.session();
    }

    public Object user() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.session().get("_sk_user");
    }

    public void setUser(ModCommon user) {
        this.ctx.session().put("_sk_user", (Object)user);
    }

    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        String sessionDomain = (String)this.ctx.session().get("cn.alphabets.light.sk_domain");
        if (sessionDomain != null) {
            return sessionDomain;
        }
        return Environment.instance().getAppName();
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getCode() {
        if (this.code != null) {
            return this.code;
        }
        String sessionCode = (String)this.ctx.session().get("cn.alphabets.light.sk_code");
        if (sessionCode != null) {
            return sessionCode;
        }
        return "Default";
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String uid() {
        if (this.uid != null) {
            return this.uid;
        }
        ModCommon user = (ModCommon)this.user();
        if (user == null) {
            return null;
        }
        if (user.get_id() == null) {
            return null;
        }
        return user.get_id().toHexString();
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public TimeZone getTimeZone() {
        try {
            ModUser user = (ModUser)this.user();
            if (user != null && StringUtils.isNotEmpty((CharSequence)user.getTimezone())) {
                return TimeZone.getTimeZone(user.getTimezone());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error get user timezone , use system config timezone instead:", (Throwable)e);
        }
        String conftz = ConfigManager.INSTANCE.getString("app.timezone");
        if (conftz != null) {
            return TimeZone.getTimeZone(conftz);
        }
        return TimeZone.getDefault();
    }

    public String getLang() {
        Cookie uaLang = this.ctx.getCookie("light.lang");
        if (uaLang != null) {
            return uaLang.getValue();
        }
        uaLang = this.ctx.getCookie("Accept-Language");
        if (uaLang != null) {
            return uaLang.getValue().split(",")[0];
        }
        return "zh";
    }
}

