/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http;

import cn.alphabets.light.exception.BadRequestException;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public interface CSRFHandler
extends Handler<RoutingContext> {
    public static final String DEFAULT_COOKIE_NAME = "XSRF-TOKEN";
    public static final String DEFAULT_HEADER_NAME = "X-XSRF-TOKEN";
    public static final String DEFAULT_QUERY_NAME = "_csrf";

    public static CSRFHandler create(String secret) {
        return new CSRFHandlerImpl(secret);
    }

    public CSRFHandler setTimeout(long var1);

    public static class CSRFHandlerImpl
    implements CSRFHandler {
        private static final Logger log = LoggerFactory.getLogger(CSRFHandlerImpl.class);
        private static final Base64.Encoder BASE64 = Base64.getMimeEncoder();
        private final Random RAND = new SecureRandom();
        private final Mac mac;
        private boolean nagHttps;
        private String cookieName = "XSRF-TOKEN";
        private String headerName = "X-XSRF-TOKEN";
        private String queryName = "_csrf";
        private long timeout = 1800000L;

        CSRFHandlerImpl(String secret) {
            try {
                this.mac = Mac.getInstance("HmacSHA256");
                this.mac.init(new SecretKeySpec(secret.getBytes(), "HmacSHA256"));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        public CSRFHandler setCookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public CSRFHandler setHeaderName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public CSRFHandler setQueryName(String queryName) {
            this.queryName = queryName;
            return this;
        }

        @Override
        public CSRFHandler setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public CSRFHandler setNagHttps(boolean nag) {
            this.nagHttps = nag;
            return this;
        }

        private String generateToken() {
            byte[] salt = new byte[32];
            this.RAND.nextBytes(salt);
            String saltPlusToken = BASE64.encodeToString(salt) + "." + Long.toString(System.currentTimeMillis());
            String signature = BASE64.encodeToString(this.mac.doFinal(saltPlusToken.getBytes()));
            return saltPlusToken + "." + signature;
        }

        private boolean validateToken(String header) {
            if (header == null) {
                return false;
            }
            String[] tokens = header.split("\\.");
            if (tokens.length != 3) {
                return false;
            }
            String saltPlusToken = tokens[0] + "." + tokens[1];
            String signature = BASE64.encodeToString(this.mac.doFinal(saltPlusToken.getBytes()));
            if (!signature.equals(tokens[2])) {
                return false;
            }
            try {
                return System.currentTimeMillis() <= Long.parseLong(tokens[1]) + this.timeout;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public void handle(RoutingContext ctx) {
            String uri;
            if (this.nagHttps && !(uri = ctx.request().absoluteURI()).startsWith("https:")) {
                log.warn((Object)("Using session cookies without https could make you susceptible to session hijacking: " + uri));
            }
            HttpMethod method = ctx.request().method();
            switch (method) {
                case GET: {
                    String token = this.generateToken();
                    ctx.put(this.headerName, (Object)token);
                    ctx.addCookie(Cookie.cookie((String)this.cookieName, (String)token));
                    ctx.next();
                    break;
                }
                case POST: 
                case PUT: 
                case DELETE: 
                case PATCH: {
                    String value = ctx.request().getHeader(this.headerName);
                    if (value == null) {
                        value = ctx.request().getFormAttribute(this.headerName);
                    }
                    if (value == null) {
                        value = ctx.request().params().get(this.queryName);
                    }
                    if (this.validateToken(value)) {
                        ctx.next();
                        break;
                    }
                    ctx.fail((Throwable)new BadRequestException("CSRF error."));
                    break;
                }
                default: {
                    ctx.next();
                }
            }
        }
    }
}

