/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.http;

import cn.alphabets.light.Helper;
import cn.alphabets.light.config.ConfigManager;
import cn.alphabets.light.http.Result;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public interface AuthHandler
extends Handler<RoutingContext> {
    public static AuthHandler create() {
        return new AuthHandlerImpl();
    }

    public static class AuthHandlerImpl
    implements AuthHandler {
        private Pattern ignore;
        private HttpResponseStatus errorStatus = HttpResponseStatus.UNAUTHORIZED;

        AuthHandlerImpl() {
            List<String> paths = ConfigManager.INSTANCE.getIgnoreAuth();
            if (CollectionUtils.isNotEmpty(paths)) {
                String regex = StringUtils.join(paths, (String)"|");
                this.ignore = Pattern.compile(regex.replaceAll("(?<!\\.)\\*", ".*"));
            }
        }

        public void handle(RoutingContext ctx) {
            String path = ctx.request().path();
            if (this.ignore != null && this.ignore.matcher(path).matches()) {
                ctx.next();
                return;
            }
            if (ctx.session().get("_sk_user") == null) {
                if (Helper.isBrowser(ctx.request())) {
                    Result.redirect(ctx, ConfigManager.INSTANCE.getString("app.home"));
                } else {
                    ctx.response().setStatusCode(this.errorStatus.code()).end(this.errorStatus.reasonPhrase());
                }
            } else {
                ctx.next();
            }
        }
    }
}

